/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import org.keycloak.models.map.common.AbstractEntity;

public class Serialization {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static <T extends AbstractEntity> T from(T orig) {
        if (orig == null) {
            return null;
        }
        try {
            AbstractEntity res = (AbstractEntity)MAPPER.readValue(MAPPER.writeValueAsBytes(orig), orig.getClass());
            return (T)res;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static {
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        MAPPER.addMixIn(AbstractEntity.class, IgnoreUpdatedMixIn.class);
    }

    abstract class IgnoreUpdatedMixIn {
        IgnoreUpdatedMixIn() {
        }

        @JsonIgnore
        public abstract boolean isUpdated();
    }
}

