/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.AuthorizationProviderFactory;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.client.clienttype.ClientType;
import org.keycloak.client.clienttype.ClientTypeException;
import org.keycloak.client.clienttype.ClientTypeManager;
import org.keycloak.common.Profile;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.common.util.UriUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.deployment.DeployedConfigurationsManager;
import org.keycloak.migration.migrators.MigrationUtils;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.credential.dto.OTPCredentialData;
import org.keycloak.models.credential.dto.OTPSecretData;
import org.keycloak.models.credential.dto.PasswordCredentialData;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.policy.PasswordPolicyNotMetException;
import org.keycloak.protocol.saml.util.ArtifactBindingUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.OrganizationDomainRepresentation;
import org.keycloak.representations.idm.OrganizationRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.PermissionTicketRepresentation;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;

public class RepresentationToModel {
    private static Logger logger = Logger.getLogger(RepresentationToModel.class);
    public static final String OIDC = "openid-connect";

    public static void importRealm(KeycloakSession session, RealmRepresentation rep, RealmModel newRealm, boolean skipUserDependent) {
        ((DatastoreProvider)session.getProvider(DatastoreProvider.class)).getExportImportManager().importRealm(rep, newRealm, skipUserDependent);
    }

    public static void importRoles(RolesRepresentation realmRoles, RealmModel realm) {
        RoleModel role;
        ClientModel client;
        if (realmRoles == null) {
            return;
        }
        if (realmRoles.getRealm() != null) {
            for (RoleRepresentation roleRepresentation : realmRoles.getRealm()) {
                if (realm.getDefaultRole().getName().equals(roleRepresentation.getName())) continue;
                RepresentationToModel.createRole(realm, roleRepresentation);
            }
        }
        if (realmRoles.getClient() != null) {
            for (Map.Entry entry : realmRoles.getClient().entrySet()) {
                client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                }
                for (RoleRepresentation roleRep : (List)entry.getValue()) {
                    role = roleRep.getId() != null ? client.addRole(roleRep.getId(), roleRep.getName()) : client.addRole(roleRep.getName());
                    role.setDescription(roleRep.getDescription());
                    if (roleRep.getAttributes() == null) continue;
                    roleRep.getAttributes().forEach((key, value) -> role.setAttribute(key, value));
                }
            }
        }
        if (realmRoles.getRealm() != null) {
            for (RoleRepresentation roleRepresentation : realmRoles.getRealm()) {
                RoleModel role2 = realm.getRole(roleRepresentation.getName());
                RepresentationToModel.addComposites(role2, roleRepresentation, realm);
            }
        }
        if (realmRoles.getClient() != null) {
            for (Map.Entry entry : realmRoles.getClient().entrySet()) {
                client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                }
                for (RoleRepresentation roleRep : (List)entry.getValue()) {
                    role = client.getRole(roleRep.getName());
                    RepresentationToModel.addComposites(role, roleRep, realm);
                }
            }
        }
    }

    public static void importGroup(RealmModel realm, GroupModel parent, GroupRepresentation group) {
        GroupModel newGroup = realm.createGroup(group.getId(), group.getName(), parent);
        if (group.getAttributes() != null) {
            for (Map.Entry attr : group.getAttributes().entrySet()) {
                newGroup.setAttribute((String)attr.getKey(), (List)attr.getValue());
            }
        }
        if (group.getRealmRoles() != null) {
            for (String roleString : group.getRealmRoles()) {
                RoleModel role = realm.getRole(roleString.trim());
                if (role == null) {
                    role = realm.addRole(roleString.trim());
                }
                newGroup.grantRole(role);
            }
        }
        if (group.getClientRoles() != null) {
            for (Map.Entry entry : group.getClientRoles().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                List roleNames = (List)entry.getValue();
                for (String roleName : roleNames) {
                    RoleModel role = client.getRole(roleName.trim());
                    if (role == null) {
                        role = client.addRole(roleName.trim());
                    }
                    newGroup.grantRole(role);
                }
            }
        }
        if (group.getSubGroups() != null) {
            for (GroupRepresentation subGroup : group.getSubGroups()) {
                RepresentationToModel.importGroup(realm, newGroup, subGroup);
            }
        }
    }

    private static void convertDeprecatedCredentialsFormat(UserRepresentation user) {
        if (user.getCredentials() != null) {
            for (CredentialRepresentation cred : user.getCredentials()) {
                try {
                    PasswordCredentialData credentialData;
                    if (cred.getCredentialData() != null && cred.getSecretData() != null || cred.getValue() != null) continue;
                    logger.warnf("Using deprecated 'credentials' format in JSON representation for user '%s'. It will be removed in future versions", (Object)user.getUsername());
                    if ("password".equals(cred.getType()) || "password-history".equals(cred.getType())) {
                        credentialData = new PasswordCredentialData(cred.getHashIterations().intValue(), cred.getAlgorithm());
                        cred.setCredentialData(JsonSerialization.writeValueAsString((Object)credentialData));
                        cred.setSecretData("{\"value\":\"" + cred.getHashedSaltedValue() + "\",\"salt\":\"" + cred.getSalt() + "\"}");
                        cred.setPriority(Integer.valueOf(10));
                        continue;
                    }
                    if (!"totp".equals(cred.getType()) && !"hotp".equals(cred.getType())) continue;
                    credentialData = new OTPCredentialData(cred.getType(), cred.getDigits().intValue(), cred.getCounter().intValue(), cred.getPeriod().intValue(), cred.getAlgorithm(), null);
                    OTPSecretData secretData = new OTPSecretData(cred.getHashedSaltedValue());
                    cred.setCredentialData(JsonSerialization.writeValueAsString((Object)credentialData));
                    cred.setSecretData(JsonSerialization.writeValueAsString((Object)secretData));
                    cred.setPriority(Integer.valueOf(20));
                    cred.setType("otp");
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
    }

    public static void updateRealm(RealmRepresentation rep, RealmModel realm, KeycloakSession session) {
        ((DatastoreProvider)session.getProvider(DatastoreProvider.class)).getExportImportManager().updateRealm(rep, realm);
    }

    public static RoleModel createRole(RealmModel newRealm, RoleRepresentation roleRep) {
        RoleModel role;
        RoleModel roleModel = role = roleRep.getId() != null ? newRealm.addRole(roleRep.getId(), roleRep.getName()) : newRealm.addRole(roleRep.getName());
        if (roleRep.getDescription() != null) {
            role.setDescription(roleRep.getDescription());
        }
        if (roleRep.getAttributes() != null) {
            for (Map.Entry attribute : roleRep.getAttributes().entrySet()) {
                role.setAttribute((String)attribute.getKey(), (List)attribute.getValue());
            }
        }
        return role;
    }

    private static void addComposites(RoleModel role, RoleRepresentation roleRep, RealmModel realm) {
        if (roleRep.getComposites() == null) {
            return;
        }
        if (roleRep.getComposites().getRealm() != null) {
            for (String string : roleRep.getComposites().getRealm()) {
                RoleModel realmRole = realm.getRole(string);
                if (realmRole == null) {
                    throw new RuntimeException("Unable to find composite realm role: " + string);
                }
                role.addCompositeRole(realmRole);
            }
        }
        if (roleRep.getComposites().getClient() != null) {
            for (Map.Entry entry : roleRep.getComposites().getClient().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + roleRep.getName());
                }
                for (String roleStr : (List)entry.getValue()) {
                    RoleModel clientRole = client.getRole(roleStr);
                    if (clientRole == null) {
                        throw new RuntimeException("Unable to find composite client role: " + roleStr);
                    }
                    role.addCompositeRole(clientRole);
                }
            }
        }
    }

    public static ClientModel createClient(KeycloakSession session, RealmModel realm, ClientRepresentation resourceRep) {
        return RepresentationToModel.createClient(session, realm, resourceRep, null);
    }

    public static ClientModel createClient(KeycloakSession session, RealmModel realm, ClientRepresentation resourceRep, Map<String, String> mappedFlows) {
        ClientModel client;
        logger.debugv("Create client: {0}", (Object)resourceRep.getClientId());
        ClientModel clientModel = client = resourceRep.getId() != null ? realm.addClient(resourceRep.getId(), resourceRep.getClientId()) : realm.addClient(resourceRep.getClientId());
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLIENT_TYPES) && resourceRep.getType() != null) {
            Iterator mgr = (ClientTypeManager)session.getProvider(ClientTypeManager.class);
            ClientType clientType = mgr.getClientType(realm, resourceRep.getType());
            client = clientType.augment(client);
        }
        RepresentationToModel.updateClientProperties(client, resourceRep, true);
        if (resourceRep.isDirectGrantsOnly() != null) {
            logger.warn((Object)"Using deprecated 'directGrantsOnly' configuration in JSON representation. It will be removed in future versions");
            client.setStandardFlowEnabled(resourceRep.isDirectGrantsOnly() == false);
            client.setDirectAccessGrantsEnabled(resourceRep.isDirectGrantsOnly().booleanValue());
        }
        if ("saml".equals(resourceRep.getProtocol()) && (resourceRep.getAttributes() == null || !resourceRep.getAttributes().containsKey("saml.artifact.binding.identifier"))) {
            client.setAttribute("saml.artifact.binding.identifier", ArtifactBindingUtils.computeArtifactBindingIdentifierString(resourceRep.getClientId()));
        }
        if (resourceRep.getAuthenticationFlowBindingOverrides() != null) {
            for (Map.Entry entry : resourceRep.getAuthenticationFlowBindingOverrides().entrySet()) {
                if (entry.getValue() == null || ((String)entry.getValue()).trim().equals("")) continue;
                String flowId = (String)entry.getValue();
                if (mappedFlows != null && mappedFlows.containsKey(flowId)) {
                    flowId = mappedFlows.get(flowId);
                }
                if (client.getRealm().getAuthenticationFlowById(flowId) == null) {
                    throw new RuntimeException("Unable to resolve auth flow binding override for: " + (String)entry.getKey());
                }
                client.setAuthenticationFlowBindingOverride((String)entry.getKey(), flowId);
            }
        }
        if (resourceRep.getRegisteredNodes() != null) {
            for (Map.Entry entry : resourceRep.getRegisteredNodes().entrySet()) {
                client.registerNode((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
        }
        if (resourceRep.getProtocolMappers() != null) {
            client.getProtocolMappersStream().collect(Collectors.toList()).forEach(arg_0 -> ((ClientModel)client).removeProtocolMapper(arg_0));
            for (ProtocolMapperRepresentation mapper : resourceRep.getProtocolMappers()) {
                client.addProtocolMapper(RepresentationToModel.toModel(mapper));
            }
            MigrationUtils.updateProtocolMappers((ProtocolMapperContainerModel)client);
        }
        if (resourceRep.getClientTemplate() != null) {
            String clientTemplateName = KeycloakModelUtils.convertClientScopeName(resourceRep.getClientTemplate());
            RepresentationToModel.addClientScopeToClient(realm, client, clientTemplateName, true);
        }
        RepresentationToModel.updateClientScopes(resourceRep, client);
        client.updateClient();
        resourceRep.setId(client.getId());
        return client;
    }

    private static void addClientScopeToClient(RealmModel realm, ClientModel client, String clientScopeName, boolean defaultScope) {
        ClientScopeModel clientScope = KeycloakModelUtils.getClientScopeByName(realm, clientScopeName);
        if (clientScope != null) {
            client.addClientScope(clientScope, defaultScope);
        } else {
            logger.warnf("Referenced client scope '%s' doesn't exist. Ignoring", (Object)clientScopeName);
        }
    }

    public static void updateClient(ClientRepresentation rep, ClientModel resource, final KeycloakSession session) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLIENT_TYPES)) {
            if (!ObjectUtil.isEqualOrBothNull((Object)resource.getType(), (Object)rep.getType())) {
                throw ClientTypeException.Message.CANNOT_CHANGE_CLIENT_TYPE.exception(new Object[0]);
            }
            if (rep.getType() != null) {
                RealmModel realm = session.getContext().getRealm();
                ClientTypeManager mgr = (ClientTypeManager)session.getProvider(ClientTypeManager.class);
                Iterator clientType = mgr.getClientType(realm, rep.getType());
                resource = clientType.augment(resource);
            }
        }
        final String newClientId = rep.getClientId();
        final String previousClientId = resource.getClientId();
        if (newClientId != null) {
            resource.setClientId(newClientId);
        }
        RepresentationToModel.updateClientProperties(resource, rep, false);
        if ("saml".equals(rep.getProtocol()) && (rep.getAttributes() == null || !rep.getAttributes().containsKey("saml.artifact.binding.identifier"))) {
            resource.setAttribute("saml.artifact.binding.identifier", ArtifactBindingUtils.computeArtifactBindingIdentifierString(newClientId));
        }
        if (rep.getAuthenticationFlowBindingOverrides() != null) {
            for (Map.Entry entry : rep.getAuthenticationFlowBindingOverrides().entrySet()) {
                if (entry.getValue() == null || ((String)entry.getValue()).trim().equals("")) {
                    resource.removeAuthenticationFlowBindingOverride((String)entry.getKey());
                    continue;
                }
                String flowId = (String)entry.getValue();
                if (resource.getRealm().getAuthenticationFlowById(flowId) == null) {
                    throw new RuntimeException("Unable to resolve auth flow binding override for: " + (String)entry.getKey());
                }
                resource.setAuthenticationFlowBindingOverride((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (rep.getRegisteredNodes() != null) {
            for (Map.Entry entry : rep.getRegisteredNodes().entrySet()) {
                resource.registerNode((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
        }
        resource.updateClient();
        if (!Objects.equals(newClientId, previousClientId)) {
            final ClientModel finalResource = resource;
            ClientModel.ClientIdChangeEvent event = new ClientModel.ClientIdChangeEvent(){

                public ClientModel getUpdatedClient() {
                    return finalResource;
                }

                public String getPreviousClientId() {
                    return previousClientId;
                }

                public String getNewClientId() {
                    return newClientId;
                }

                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            };
            session.getKeycloakSessionFactory().publish((ProviderEvent)event);
        }
    }

    private static void updateClientProperties(final ClientModel client, final ClientRepresentation rep, final boolean isNew) {
        List propertyUpdateExceptions;
        LinkedList<Supplier<ClientTypeException>> clientPropertyUpdates = new LinkedList<Supplier<ClientTypeException>>(){
            {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = () -> ((ClientRepresentation)rep).getName();
                supplierArray[1] = () -> ((ClientModel)client).getName();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setName(arg_0), supplierArray));
                Supplier[] supplierArray2 = new Supplier[2];
                supplierArray2[0] = () -> ((ClientRepresentation)rep).getDescription();
                supplierArray2[1] = () -> ((ClientModel)client).getDescription();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setDescription(arg_0), supplierArray2));
                Supplier[] supplierArray3 = new Supplier[2];
                supplierArray3[0] = () -> ((ClientRepresentation)rep).getType();
                supplierArray3[1] = () -> ((ClientModel)client).getType();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setType(arg_0), supplierArray3));
                Supplier[] supplierArray4 = new Supplier[2];
                supplierArray4[0] = () -> ((ClientRepresentation)rep).isEnabled();
                supplierArray4[1] = () -> ((ClientModel)client).isEnabled();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setEnabled(arg_0), supplierArray4));
                Supplier[] supplierArray5 = new Supplier[2];
                supplierArray5[0] = () -> ((ClientRepresentation)rep).isAlwaysDisplayInConsole();
                supplierArray5[1] = () -> ((ClientModel)client).isAlwaysDisplayInConsole();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setAlwaysDisplayInConsole(arg_0), supplierArray5));
                Supplier[] supplierArray6 = new Supplier[2];
                supplierArray6[0] = () -> ((ClientRepresentation)rep).getAdminUrl();
                supplierArray6[1] = () -> ((ClientModel)client).getManagementUrl();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setManagementUrl(arg_0), supplierArray6));
                Supplier[] supplierArray7 = new Supplier[2];
                supplierArray7[0] = () -> ((ClientRepresentation)rep).isSurrogateAuthRequired();
                supplierArray7[1] = () -> ((ClientModel)client).isSurrogateAuthRequired();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setSurrogateAuthRequired(arg_0), supplierArray7));
                Supplier[] supplierArray8 = new Supplier[2];
                supplierArray8[0] = () -> ((ClientRepresentation)rep).getRootUrl();
                supplierArray8[1] = () -> ((ClientModel)client).getRootUrl();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setRootUrl(arg_0), supplierArray8));
                Supplier[] supplierArray9 = new Supplier[2];
                supplierArray9[0] = () -> ((ClientRepresentation)rep).getBaseUrl();
                supplierArray9[1] = () -> ((ClientModel)client).getBaseUrl();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setBaseUrl(arg_0), supplierArray9));
                Supplier[] supplierArray10 = new Supplier[2];
                supplierArray10[0] = () -> ((ClientRepresentation)rep).isBearerOnly();
                supplierArray10[1] = () -> ((ClientModel)client).isBearerOnly();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setBearerOnly(arg_0), supplierArray10));
                Supplier[] supplierArray11 = new Supplier[2];
                supplierArray11[0] = () -> ((ClientRepresentation)rep).isConsentRequired();
                supplierArray11[1] = () -> ((ClientModel)client).isConsentRequired();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setConsentRequired(arg_0), supplierArray11));
                Supplier[] supplierArray12 = new Supplier[2];
                supplierArray12[0] = () -> ((ClientRepresentation)rep).isStandardFlowEnabled();
                supplierArray12[1] = () -> ((ClientModel)client).isStandardFlowEnabled();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setStandardFlowEnabled(arg_0), supplierArray12));
                Supplier[] supplierArray13 = new Supplier[2];
                supplierArray13[0] = () -> ((ClientRepresentation)rep).isImplicitFlowEnabled();
                supplierArray13[1] = () -> ((ClientModel)client).isImplicitFlowEnabled();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setImplicitFlowEnabled(arg_0), supplierArray13));
                Supplier[] supplierArray14 = new Supplier[2];
                supplierArray14[0] = () -> ((ClientRepresentation)rep).isDirectAccessGrantsEnabled();
                supplierArray14[1] = () -> ((ClientModel)client).isDirectAccessGrantsEnabled();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setDirectAccessGrantsEnabled(arg_0), supplierArray14));
                Supplier[] supplierArray15 = new Supplier[2];
                supplierArray15[0] = () -> ((ClientRepresentation)rep).isServiceAccountsEnabled();
                supplierArray15[1] = () -> ((ClientModel)client).isServiceAccountsEnabled();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setServiceAccountsEnabled(arg_0), supplierArray15));
                Supplier[] supplierArray16 = new Supplier[2];
                supplierArray16[0] = () -> ((ClientRepresentation)rep).isPublicClient();
                supplierArray16[1] = () -> ((ClientModel)client).isPublicClient();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setPublicClient(arg_0), supplierArray16));
                Supplier[] supplierArray17 = new Supplier[2];
                supplierArray17[0] = () -> ((ClientRepresentation)rep).isFrontchannelLogout();
                supplierArray17[1] = () -> ((ClientModel)client).isFrontchannelLogout();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setFrontchannelLogout(arg_0), supplierArray17));
                Supplier[] supplierArray18 = new Supplier[2];
                supplierArray18[0] = () -> ((ClientRepresentation)rep).getNotBefore();
                supplierArray18[1] = () -> ((ClientModel)client).getNotBefore();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setNotBefore(arg_0), supplierArray18));
                Supplier[] supplierArray19 = new Supplier[3];
                supplierArray19[0] = () -> ((ClientRepresentation)rep).getProtocol();
                supplierArray19[1] = () -> ((ClientModel)client).getProtocol();
                supplierArray19[2] = () -> RepresentationToModel.OIDC;
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setProtocol(arg_0), supplierArray19));
                Supplier[] supplierArray20 = new Supplier[2];
                supplierArray20[0] = () -> ((ClientRepresentation)rep).getNodeReRegistrationTimeout();
                supplierArray20[1] = () -> RepresentationToModel.defaultNodeReRegistrationTimeout(client, isNew);
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setNodeReRegistrationTimeout(arg_0), supplierArray20));
                Supplier[] supplierArray21 = new Supplier[3];
                supplierArray21[0] = () -> ((ClientRepresentation)rep).getClientAuthenticatorType();
                supplierArray21[1] = () -> ((ClientModel)client).getClientAuthenticatorType();
                supplierArray21[2] = KeycloakModelUtils::getDefaultClientAuthenticatorType;
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setClientAuthenticatorType(arg_0), supplierArray21));
                Supplier[] supplierArray22 = new Supplier[2];
                supplierArray22[0] = () -> ((ClientRepresentation)rep).isFullScopeAllowed();
                supplierArray22[1] = () -> RepresentationToModel.defaultFullScopeAllowed(client, isNew);
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setFullScopeAllowed(arg_0), supplierArray22));
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setSecret(arg_0), () -> RepresentationToModel.determineNewSecret(client, rep)));
                Supplier[] supplierArray23 = new Supplier[2];
                supplierArray23[0] = () -> CollectionUtil.collectionToSet((Collection)rep.getRedirectUris());
                supplierArray23[1] = () -> ((ClientModel)client).getRedirectUris();
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setRedirectUris(arg_0), supplierArray23));
                this.add(RepresentationToModel.updatePropertyAction(arg_0 -> ((ClientModel)client).setWebOrigins(arg_0), () -> CollectionUtil.collectionToSet((Collection)rep.getWebOrigins()), () -> RepresentationToModel.defaultWebOrigins(client)));
            }
        };
        if (rep.getAttributes() != null) {
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = entry::getValue;
                clientPropertyUpdates.add(RepresentationToModel.updatePropertyAction(val -> client.setAttribute((String)entry.getKey(), val), supplierArray));
            }
        }
        if ((propertyUpdateExceptions = clientPropertyUpdates.stream().map(Supplier::get).filter(Objects::nonNull).collect(Collectors.toList())).size() > 0) {
            Object[] paramsWithFailures = propertyUpdateExceptions.stream().map(ModelException::getParameters).flatMap(Stream::of).toArray();
            throw ClientTypeException.Message.CLIENT_UPDATE_FAILED_CLIENT_TYPE_VALIDATION.exception(paramsWithFailures);
        }
    }

    private static Boolean defaultFullScopeAllowed(ClientModel client, boolean isNew) {
        return isNew && !client.isFullScopeAllowed() ? !client.isConsentRequired() : client.isFullScopeAllowed();
    }

    private static Integer defaultNodeReRegistrationTimeout(ClientModel client, boolean isNew) {
        if (isNew && Objects.equals(client.getNodeReRegistrationTimeout(), 0)) {
            return -1;
        }
        return client.getNodeReRegistrationTimeout();
    }

    private static String determineNewSecret(ClientModel client, ClientRepresentation rep) {
        if (client.isPublicClient() || client.isBearerOnly()) {
            return null;
        }
        String currentSecret = client.getSecret();
        String newSecret = rep.getSecret();
        if (newSecret == null && currentSecret == null) {
            return KeycloakModelUtils.generateSecret(client);
        }
        if (newSecret != null) {
            return newSecret;
        }
        return currentSecret;
    }

    private static Set<String> defaultWebOrigins(ClientModel client) {
        Set webOrigins = client.getWebOrigins();
        if (webOrigins != null && !webOrigins.isEmpty()) {
            return webOrigins;
        }
        Set redirectUris = client.getRedirectUris();
        if (redirectUris == null || redirectUris.isEmpty()) {
            return new HashSet<String>();
        }
        return client.getRedirectUris().stream().filter(uri -> uri.startsWith("http")).map(UriUtils::getOrigin).collect(Collectors.toSet());
    }

    public static void updateClientProtocolMappers(ClientRepresentation rep, ClientModel resource) {
        if (rep.getProtocolMappers() != null) {
            Map existingProtocolMappers = resource.getProtocolMappersStream().collect(Collectors.toMap(mapper -> RepresentationToModel.generateProtocolNameKey(mapper.getProtocol(), mapper.getName()), Function.identity()));
            for (ProtocolMapperRepresentation protocolMapperRepresentation : rep.getProtocolMappers()) {
                String protocolNameKey = RepresentationToModel.generateProtocolNameKey(protocolMapperRepresentation.getProtocol(), protocolMapperRepresentation.getName());
                ProtocolMapperModel existingMapper = (ProtocolMapperModel)existingProtocolMappers.get(protocolNameKey);
                if (existingMapper != null) {
                    ProtocolMapperModel updatedProtocolMapperModel = RepresentationToModel.toModel(protocolMapperRepresentation);
                    updatedProtocolMapperModel.setId(existingMapper.getId());
                    resource.updateProtocolMapper(updatedProtocolMapperModel);
                    existingProtocolMappers.remove(protocolNameKey);
                    continue;
                }
                resource.addProtocolMapper(RepresentationToModel.toModel(protocolMapperRepresentation));
            }
            for (Map.Entry entry : existingProtocolMappers.entrySet()) {
                resource.removeProtocolMapper((ProtocolMapperModel)entry.getValue());
            }
        }
    }

    public static void updateClientScopes(ClientRepresentation resourceRep, ClientModel client) {
        if (resourceRep.getDefaultClientScopes() != null || resourceRep.getOptionalClientScopes() != null) {
            for (ClientScopeModel clientScope : client.getClientScopes(true).values()) {
                client.removeClientScope(clientScope);
            }
            for (ClientScopeModel clientScope : client.getClientScopes(false).values()) {
                client.removeClientScope(clientScope);
            }
        }
        if (resourceRep.getDefaultClientScopes() != null) {
            for (String clientScopeName : resourceRep.getDefaultClientScopes()) {
                RepresentationToModel.addClientScopeToClient(client.getRealm(), client, clientScopeName, true);
            }
        }
        if (resourceRep.getOptionalClientScopes() != null) {
            for (String clientScopeName : resourceRep.getOptionalClientScopes()) {
                RepresentationToModel.addClientScopeToClient(client.getRealm(), client, clientScopeName, false);
            }
        }
    }

    private static <T> Supplier<ClientTypeException> updateProperty(Consumer<T> modelSetter, Supplier<T> representationGetter) {
        return () -> {
            try {
                Object value = representationGetter.get();
                modelSetter.accept(value);
            }
            catch (ClientTypeException cte) {
                return cte;
            }
            return null;
        };
    }

    @SafeVarargs
    private static <T> Supplier<ClientTypeException> updatePropertyAction(Consumer<T> modelSetter, Supplier<T> ... getters) {
        Stream<Object> firstNonNullSupplied = Stream.of(getters).map(Supplier::get).filter(Objects::nonNull);
        return RepresentationToModel.updateProperty(modelSetter, () -> firstNonNullSupplied.findFirst().orElse(null));
    }

    private static String generateProtocolNameKey(String protocol, String name) {
        return String.format("%s%%%s", protocol, name);
    }

    public static ClientScopeModel createClientScope(KeycloakSession session, RealmModel realm, ClientScopeRepresentation resourceRep) {
        ClientScopeModel clientScope;
        logger.debugv("Create client scope: {0}", (Object)resourceRep.getName());
        ClientScopeModel clientScopeModel = clientScope = resourceRep.getId() != null ? realm.addClientScope(resourceRep.getId(), resourceRep.getName()) : realm.addClientScope(resourceRep.getName());
        if (resourceRep.getName() != null) {
            clientScope.setName(resourceRep.getName());
        }
        if (resourceRep.getDescription() != null) {
            clientScope.setDescription(resourceRep.getDescription());
        }
        if (resourceRep.getProtocol() != null) {
            clientScope.setProtocol(resourceRep.getProtocol());
        }
        if (resourceRep.getProtocolMappers() != null) {
            clientScope.getProtocolMappersStream().collect(Collectors.toList()).forEach(arg_0 -> ((ClientScopeModel)clientScope).removeProtocolMapper(arg_0));
            for (ProtocolMapperRepresentation mapper : resourceRep.getProtocolMappers()) {
                clientScope.addProtocolMapper(RepresentationToModel.toModel(mapper));
            }
            MigrationUtils.updateProtocolMappers((ProtocolMapperContainerModel)clientScope);
        }
        if (resourceRep.getAttributes() != null) {
            for (Map.Entry entry : resourceRep.getAttributes().entrySet()) {
                clientScope.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return clientScope;
    }

    public static void updateClientScope(ClientScopeRepresentation rep, ClientScopeModel resource) {
        if (rep.getName() != null) {
            resource.setName(rep.getName());
        }
        if (rep.getDescription() != null) {
            resource.setDescription(rep.getDescription());
        }
        if (rep.getProtocol() != null) {
            resource.setProtocol(rep.getProtocol());
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                resource.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public static UserModel createUser(KeycloakSession session, RealmModel newRealm, UserRepresentation userRep) {
        return ((DatastoreProvider)session.getProvider(DatastoreProvider.class)).getExportImportManager().createUser(newRealm, userRep);
    }

    public static void createGroups(KeycloakSession session, UserRepresentation userRep, RealmModel newRealm, UserModel user) {
        if (userRep.getGroups() != null) {
            for (String path : userRep.getGroups()) {
                GroupModel group = KeycloakModelUtils.findGroupByPath(session, newRealm, path);
                if (group == null) {
                    throw new RuntimeException("Unable to find group specified by path: " + path);
                }
                user.joinGroup(group);
            }
        }
    }

    public static void createFederatedIdentities(UserRepresentation userRep, KeycloakSession session, RealmModel realm, UserModel user) {
        if (userRep.getFederatedIdentities() != null) {
            for (FederatedIdentityRepresentation identity : userRep.getFederatedIdentities()) {
                FederatedIdentityModel mappingModel = new FederatedIdentityModel(identity.getIdentityProvider(), identity.getUserId(), identity.getUserName());
                session.users().addFederatedIdentity(realm, user, mappingModel);
            }
        }
    }

    public static void createCredentials(UserRepresentation userRep, KeycloakSession session, RealmModel realm, UserModel user, boolean adminRequest) {
        RepresentationToModel.convertDeprecatedCredentialsFormat(userRep);
        if (userRep.getCredentials() != null) {
            for (CredentialRepresentation cred : userRep.getCredentials()) {
                if (cred.getId() != null && user.credentialManager().getStoredCredentialById(cred.getId()) != null) continue;
                if (cred.getValue() != null && !cred.getValue().isEmpty()) {
                    RealmModel origRealm = session.getContext().getRealm();
                    try {
                        session.getContext().setRealm(realm);
                        user.credentialManager().updateCredential((CredentialInput)UserCredentialModel.password((String)cred.getValue(), (boolean)false));
                        continue;
                    }
                    catch (ModelException ex) {
                        PasswordPolicyNotMetException passwordPolicyNotMetException = new PasswordPolicyNotMetException(ex.getMessage(), user.getUsername(), (Throwable)ex);
                        passwordPolicyNotMetException.setParameters(ex.getParameters());
                        throw passwordPolicyNotMetException;
                    }
                    finally {
                        session.getContext().setRealm(origRealm);
                        continue;
                    }
                }
                user.credentialManager().createCredentialThroughProvider(RepresentationToModel.toModel(cred));
            }
        }
    }

    public static CredentialModel toModel(CredentialRepresentation cred) {
        CredentialModel model = new CredentialModel();
        model.setCreatedDate(cred.getCreatedDate());
        model.setType(cred.getType());
        model.setUserLabel(cred.getUserLabel());
        model.setSecretData(cred.getSecretData());
        model.setCredentialData(cred.getCredentialData());
        model.setId(cred.getId());
        return model;
    }

    public static void createRoleMappings(UserRepresentation userRep, UserModel user, RealmModel realm) {
        if (userRep.getRealmRoles() != null) {
            for (String string : userRep.getRealmRoles()) {
                RoleModel role = realm.getRole(string.trim());
                if (role == null) {
                    role = realm.addRole(string.trim());
                }
                user.grantRole(role);
            }
        }
        if (userRep.getClientRoles() != null) {
            for (Map.Entry entry : userRep.getClientRoles().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                RepresentationToModel.createClientRoleMappings(client, user, (List)entry.getValue());
            }
        }
    }

    private static void createClientRoleMappings(ClientModel clientModel, UserModel user, List<String> roleNames) {
        if (user == null) {
            throw new RuntimeException("User not found");
        }
        for (String roleName : roleNames) {
            RoleModel role = clientModel.getRole(roleName.trim());
            if (role == null) {
                role = clientModel.addRole(roleName.trim());
            }
            user.grantRole(role);
        }
    }

    public static IdentityProviderModel toModel(RealmModel realm, IdentityProviderRepresentation representation, KeycloakSession session) {
        AuthenticationFlowModel flowModel;
        IdentityProviderFactory providerFactory = (IdentityProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(IdentityProvider.class, representation.getProviderId());
        if (providerFactory == null) {
            providerFactory = (IdentityProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(SocialIdentityProvider.class, representation.getProviderId());
        }
        if (providerFactory == null) {
            throw new IllegalArgumentException("Invalid identity provider id [" + representation.getProviderId() + "]");
        }
        IdentityProviderModel identityProviderModel = providerFactory.createConfig();
        identityProviderModel.setInternalId(representation.getInternalId());
        identityProviderModel.setAlias(representation.getAlias());
        identityProviderModel.setDisplayName(representation.getDisplayName());
        identityProviderModel.setProviderId(representation.getProviderId());
        identityProviderModel.setEnabled(representation.isEnabled());
        identityProviderModel.setLinkOnly(representation.isLinkOnly());
        identityProviderModel.setHideOnLogin(representation.isHideOnLogin());
        String hideOnLoginAttr = (String)representation.getConfig().remove("hideOnLoginPage");
        if (hideOnLoginAttr != null) {
            identityProviderModel.setHideOnLogin(Boolean.parseBoolean(hideOnLoginAttr));
        }
        identityProviderModel.setTrustEmail(representation.isTrustEmail());
        identityProviderModel.setAuthenticateByDefault(representation.isAuthenticateByDefault());
        identityProviderModel.setStoreToken(representation.isStoreToken());
        identityProviderModel.setAddReadTokenRoleOnCreate(representation.isAddReadTokenRoleOnCreate());
        RepresentationToModel.updateOrganizationBroker(representation, session);
        identityProviderModel.setOrganizationId(representation.getOrganizationId());
        identityProviderModel.setConfig(RepresentationToModel.removeEmptyString(representation.getConfig()));
        String flowAlias = representation.getFirstBrokerLoginFlowAlias();
        if (flowAlias == null || flowAlias.trim().isEmpty()) {
            identityProviderModel.setFirstBrokerLoginFlowId(null);
        } else {
            flowModel = realm.getFlowByAlias(flowAlias);
            if (flowModel == null) {
                throw new ModelException("No available authentication flow with alias: " + flowAlias);
            }
            identityProviderModel.setFirstBrokerLoginFlowId(flowModel.getId());
        }
        flowAlias = representation.getPostBrokerLoginFlowAlias();
        if (flowAlias == null || flowAlias.trim().isEmpty()) {
            identityProviderModel.setPostBrokerLoginFlowId(null);
        } else {
            flowModel = realm.getFlowByAlias(flowAlias);
            if (flowModel == null) {
                throw new ModelException("No available authentication flow with alias: " + flowAlias);
            }
            identityProviderModel.setPostBrokerLoginFlowId(flowModel.getId());
        }
        identityProviderModel.validate(realm);
        return identityProviderModel;
    }

    public static ProtocolMapperModel toModel(ProtocolMapperRepresentation rep) {
        ProtocolMapperModel model = new ProtocolMapperModel();
        model.setId(rep.getId());
        model.setName(rep.getName());
        model.setProtocol(rep.getProtocol());
        model.setProtocolMapper(rep.getProtocolMapper());
        model.setConfig(RepresentationToModel.removeEmptyString(rep.getConfig()));
        return model;
    }

    public static IdentityProviderMapperModel toModel(IdentityProviderMapperRepresentation rep) {
        IdentityProviderMapperModel model = new IdentityProviderMapperModel();
        model.setId(rep.getId());
        model.setName(rep.getName());
        model.setIdentityProviderAlias(rep.getIdentityProviderAlias());
        model.setIdentityProviderMapper(rep.getIdentityProviderMapper());
        model.setConfig(RepresentationToModel.removeEmptyString(rep.getConfig()));
        return model;
    }

    public static UserConsentModel toModel(RealmModel newRealm, UserConsentRepresentation consentRep) {
        ClientModel client = newRealm.getClientByClientId(consentRep.getClientId());
        if (client == null) {
            throw new RuntimeException("Unable to find client consent mappings for client: " + consentRep.getClientId());
        }
        UserConsentModel consentModel = new UserConsentModel(client);
        consentModel.setCreatedDate(consentRep.getCreatedDate());
        consentModel.setLastUpdatedDate(consentRep.getLastUpdatedDate());
        if (consentRep.getGrantedClientScopes() != null) {
            for (String scopeName : consentRep.getGrantedClientScopes()) {
                ClientScopeModel clientScope = KeycloakModelUtils.getClientScopeByName(newRealm, scopeName);
                if (clientScope == null) {
                    throw new RuntimeException("Unable to find client scope referenced in consent mappings of user. Client scope name: " + scopeName);
                }
                consentModel.addGrantedClientScope(clientScope);
            }
        }
        if (consentRep.getGrantedRealmRoles() != null && consentRep.getGrantedRealmRoles().contains("offline_access")) {
            ClientScopeModel offlineScope = (ClientScopeModel)client.getClientScopes(false).get("offline_access");
            if (offlineScope == null) {
                logger.warn((Object)"Unable to find offline_access scope referenced in grantedRoles of user");
            }
            consentModel.addGrantedClientScope(offlineScope);
        }
        return consentModel;
    }

    public static AuthenticationFlowModel toModel(AuthenticationFlowRepresentation rep) {
        AuthenticationFlowModel model = new AuthenticationFlowModel();
        model.setId(rep.getId());
        model.setBuiltIn(rep.isBuiltIn());
        model.setTopLevel(rep.isTopLevel());
        model.setProviderId(rep.getProviderId());
        model.setAlias(rep.getAlias());
        model.setDescription(rep.getDescription());
        return model;
    }

    public static AuthenticationExecutionModel toModel(KeycloakSession session, RealmModel realm, AuthenticationExecutionRepresentation rep) {
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        model.setId(rep.getId());
        model.setFlowId(rep.getFlowId());
        model.setAuthenticator(rep.getAuthenticator());
        if (rep.getPriority() != null) {
            model.setPriority(rep.getPriority().intValue());
        }
        model.setParentFlow(rep.getParentFlow());
        model.setAuthenticatorFlow(rep.isAuthenticatorFlow());
        model.setRequirement(AuthenticationExecutionModel.Requirement.valueOf((String)rep.getRequirement()));
        if (rep.getAuthenticatorConfig() != null) {
            AuthenticatorConfigModel cfg = new DeployedConfigurationsManager(session).getAuthenticatorConfigByAlias(realm, rep.getAuthenticatorConfig());
            model.setAuthenticatorConfig(cfg.getId());
        }
        return model;
    }

    public static AuthenticatorConfigModel toModel(AuthenticatorConfigRepresentation rep) {
        AuthenticatorConfigModel model = new AuthenticatorConfigModel();
        model.setId(rep.getId());
        model.setAlias(rep.getAlias());
        model.setConfig(RepresentationToModel.removeEmptyString(rep.getConfig()));
        return model;
    }

    public static ComponentModel toModel(KeycloakSession session, ComponentRepresentation rep) {
        ComponentModel model = new ComponentModel();
        model.setId(rep.getId());
        model.setParentId(rep.getParentId());
        model.setProviderType(rep.getProviderType());
        model.setProviderId(rep.getProviderId());
        model.setConfig(new MultivaluedHashMap());
        model.setName(rep.getName());
        model.setSubType(rep.getSubType());
        if (rep.getConfig() != null) {
            HashSet keys = new HashSet(rep.getConfig().keySet());
            for (String k : keys) {
                List values = (List)rep.getConfig().get((Object)k);
                if (values == null) continue;
                ListIterator itr = values.listIterator();
                while (itr.hasNext()) {
                    String v = (String)itr.next();
                    if (v != null && !v.trim().isEmpty()) continue;
                    itr.remove();
                }
                if (values.isEmpty()) continue;
                model.getConfig().put((Object)k, (Object)values);
            }
        }
        return model;
    }

    public static void updateComponent(KeycloakSession session, ComponentRepresentation rep, ComponentModel component, boolean internal) {
        if (rep.getName() != null) {
            component.setName(rep.getName());
        }
        if (rep.getParentId() != null) {
            component.setParentId(rep.getParentId());
        }
        if (rep.getProviderType() != null) {
            component.setProviderType(rep.getProviderType());
        }
        if (rep.getProviderId() != null) {
            component.setProviderId(rep.getProviderId());
        }
        if (rep.getSubType() != null) {
            component.setSubType(rep.getSubType());
        }
        Map<String, ProviderConfigProperty> providerConfiguration = null;
        if (!internal) {
            providerConfiguration = ComponentUtil.getComponentConfigProperties(session, component);
        }
        if (rep.getConfig() != null) {
            HashSet keys = new HashSet(rep.getConfig().keySet());
            for (String k : keys) {
                if (!internal && !providerConfiguration.containsKey(k)) continue;
                List values = (List)rep.getConfig().get((Object)k);
                if (values == null || values.isEmpty() || values.get(0) == null || ((String)values.get(0)).trim().isEmpty()) {
                    component.getConfig().remove((Object)k);
                    continue;
                }
                ListIterator itr = values.listIterator();
                while (itr.hasNext()) {
                    String v = (String)itr.next();
                    if (v != null && !v.trim().isEmpty() && !v.equals("**********")) continue;
                    itr.remove();
                }
                if (values.isEmpty()) continue;
                component.getConfig().put((Object)k, (Object)values);
            }
        }
    }

    public static void importAuthorizationSettings(ClientRepresentation clientRepresentation, ClientModel client, KeycloakSession session) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION) && Boolean.TRUE.equals(clientRepresentation.getAuthorizationServicesEnabled())) {
            AuthorizationProviderFactory authorizationFactory = (AuthorizationProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(AuthorizationProvider.class);
            AuthorizationProvider authorization = authorizationFactory.create(session, client.getRealm());
            client.setServiceAccountsEnabled(true);
            client.setBearerOnly(false);
            client.setPublicClient(false);
            ResourceServerRepresentation rep = clientRepresentation.getAuthorizationSettings();
            if (rep == null) {
                rep = new ResourceServerRepresentation();
            }
            rep.setClientId(client.getId());
            RepresentationToModel.toModel(rep, authorization, client);
        }
    }

    public static ResourceServer toModel(ResourceServerRepresentation rep, AuthorizationProvider authorization, ClientModel client) {
        ResourceServer resourceServer;
        ResourceServerStore resourceServerStore = authorization.getStoreFactory().getResourceServerStore();
        ResourceServer existing = resourceServerStore.findByClient(client);
        if (existing == null) {
            resourceServer = resourceServerStore.create(client);
            resourceServer.setAllowRemoteResourceManagement(true);
            resourceServer.setPolicyEnforcementMode(PolicyEnforcementMode.ENFORCING);
        } else {
            resourceServer = existing;
        }
        resourceServer.setPolicyEnforcementMode(rep.getPolicyEnforcementMode());
        resourceServer.setAllowRemoteResourceManagement(rep.isAllowRemoteResourceManagement());
        DecisionStrategy decisionStrategy = rep.getDecisionStrategy();
        if (decisionStrategy == null) {
            decisionStrategy = DecisionStrategy.UNANIMOUS;
        }
        resourceServer.setDecisionStrategy(decisionStrategy);
        for (ScopeRepresentation scope : rep.getScopes()) {
            RepresentationToModel.toModel(scope, resourceServer, authorization);
        }
        KeycloakSession session = authorization.getKeycloakSession();
        RealmModel realm = authorization.getRealm();
        for (ResourceRepresentation resource : rep.getResources()) {
            UserModel user;
            ResourceOwnerRepresentation owner = resource.getOwner();
            if (owner == null) {
                owner = new ResourceOwnerRepresentation();
                owner.setId(resourceServer.getClientId());
                resource.setOwner(owner);
            } else if (owner.getName() != null && (user = session.users().getUserByUsername(realm, owner.getName())) != null) {
                owner.setId(user.getId());
            }
            RepresentationToModel.toModel(resource, resourceServer, authorization);
        }
        RepresentationToModel.importPolicies(authorization, resourceServer, rep.getPolicies(), null);
        return resourceServer;
    }

    private static Policy importPolicies(AuthorizationProvider authorization, ResourceServer resourceServer, List<PolicyRepresentation> policiesToImport, String parentPolicyName) {
        StoreFactory storeFactory = authorization.getStoreFactory();
        for (PolicyRepresentation policyRepresentation : policiesToImport) {
            Policy policy;
            PolicyStore policyStore;
            if (parentPolicyName != null && !parentPolicyName.equals(policyRepresentation.getName())) continue;
            Map config = policyRepresentation.getConfig();
            String applyPolicies = (String)config.get("applyPolicies");
            if (applyPolicies != null && !applyPolicies.isEmpty()) {
                policyStore = storeFactory.getPolicyStore();
                try {
                    List policies = (List)JsonSerialization.readValue((String)applyPolicies, List.class);
                    HashSet<String> policyIds = new HashSet<String>();
                    for (String policyName : policies) {
                        Policy policy2 = policyStore.findByName(resourceServer, policyName);
                        if (policy2 == null) {
                            policy2 = policyStore.findById(resourceServer, policyName);
                        }
                        if (policy2 == null && (policy2 = RepresentationToModel.importPolicies(authorization, resourceServer, policiesToImport, policyName)) == null) {
                            throw new RuntimeException("Policy with name [" + policyName + "] not defined.");
                        }
                        policyIds.add(policy2.getId());
                    }
                    config.put("applyPolicies", JsonSerialization.writeValueAsString(policyIds));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while importing policy [" + policyRepresentation.getName() + "].", e);
                }
            }
            if ((policy = (policyStore = storeFactory.getPolicyStore()).findById(resourceServer, policyRepresentation.getId())) == null) {
                policy = policyStore.findByName(resourceServer, policyRepresentation.getName());
            }
            policy = policy == null ? policyStore.create(resourceServer, (AbstractPolicyRepresentation)policyRepresentation) : RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, authorization, policy);
            if (parentPolicyName == null || !parentPolicyName.equals(policyRepresentation.getName())) continue;
            return policy;
        }
        return null;
    }

    public static Policy toModel(AbstractPolicyRepresentation representation, AuthorizationProvider authorization, Policy model) {
        model.setName(representation.getName());
        model.setDescription(representation.getDescription());
        model.setDecisionStrategy(representation.getDecisionStrategy());
        model.setLogic(representation.getLogic());
        model.setResourceType(representation.getResourceType());
        Set resources = representation.getResources();
        Set scopes = representation.getScopes();
        Set policies = representation.getPolicies();
        if (representation instanceof PolicyRepresentation) {
            PolicyRepresentation policy = (PolicyRepresentation)PolicyRepresentation.class.cast(representation);
            if (resources == null) {
                String resourcesConfig = (String)policy.getConfig().get("resources");
                if (resourcesConfig != null) {
                    try {
                        resources = (Set)JsonSerialization.readValue((String)resourcesConfig, Set.class);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                representation.setResources(resources);
            }
            if (scopes == null) {
                String scopesConfig = (String)policy.getConfig().get("scopes");
                if (scopesConfig != null) {
                    try {
                        scopes = (Set)JsonSerialization.readValue((String)scopesConfig, Set.class);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                representation.setScopes(scopes);
            }
            if (policies == null) {
                String policiesConfig = (String)policy.getConfig().get("applyPolicies");
                if (policiesConfig != null) {
                    try {
                        policies = (Set)JsonSerialization.readValue((String)policiesConfig, Set.class);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                representation.setPolicies(policies);
            }
            model.setConfig(policy.getConfig());
        }
        StoreFactory storeFactory = authorization.getStoreFactory();
        RepresentationToModel.updateResources(representation, model, authorization);
        RepresentationToModel.updateScopes(representation, model, storeFactory);
        RepresentationToModel.updateAssociatedPolicies(representation, model, storeFactory);
        PolicyProviderFactory provider = authorization.getProviderFactory(model.getType());
        if (provider == null) {
            throw new RuntimeException("Couldn't find policy provider with type [" + model.getType() + "]");
        }
        if (representation instanceof PolicyRepresentation) {
            provider.onImport(model, (PolicyRepresentation)PolicyRepresentation.class.cast(representation), authorization);
        } else if (representation.getId() == null) {
            provider.onCreate(model, representation, authorization);
        } else {
            provider.onUpdate(model, representation, authorization);
        }
        representation.setId(model.getId());
        return model;
    }

    private static void updateScopes(AbstractPolicyRepresentation representation, Policy policy, StoreFactory storeFactory) {
        boolean hasScope;
        Set scopeIds = representation.getScopes();
        if (scopeIds == null) {
            return;
        }
        if (scopeIds.isEmpty()) {
            for (Scope scope : new HashSet<Scope>(policy.getScopes())) {
                policy.removeScope(scope);
            }
            return;
        }
        ResourceServer resourceServer = policy.getResourceServer();
        for (String scopeId : scopeIds) {
            hasScope = false;
            for (Scope scopeModel : new HashSet<Scope>(policy.getScopes())) {
                if (!scopeModel.getId().equals(scopeId) && !scopeModel.getName().equals(scopeId)) continue;
                hasScope = true;
            }
            if (hasScope) continue;
            Scope scope = storeFactory.getScopeStore().findById(resourceServer, scopeId);
            if (scope == null && (scope = storeFactory.getScopeStore().findByName(resourceServer, scopeId)) == null) {
                throw new RuntimeException("Scope with id or name [" + scopeId + "] does not exist");
            }
            policy.addScope(scope);
        }
        for (Scope scopeModel : new HashSet<Scope>(policy.getScopes())) {
            hasScope = false;
            for (String scopeId : scopeIds) {
                if (!scopeModel.getId().equals(scopeId) && !scopeModel.getName().equals(scopeId)) continue;
                hasScope = true;
            }
            if (hasScope) continue;
            policy.removeScope(scopeModel);
        }
        policy.removeConfig("scopes");
    }

    private static void updateAssociatedPolicies(AbstractPolicyRepresentation representation, Policy policy, StoreFactory storeFactory) {
        boolean hasPolicy;
        ResourceServer resourceServer = policy.getResourceServer();
        Set policyIds = representation.getPolicies();
        if (policyIds == null) {
            return;
        }
        if (policyIds.isEmpty()) {
            for (Policy associated : new HashSet<Policy>(policy.getAssociatedPolicies())) {
                policy.removeAssociatedPolicy(associated);
            }
            return;
        }
        PolicyStore policyStore = storeFactory.getPolicyStore();
        for (String policyId : policyIds) {
            hasPolicy = false;
            for (Policy policyModel : new HashSet<Policy>(policy.getAssociatedPolicies())) {
                if (!policyModel.getId().equals(policyId) && !policyModel.getName().equals(policyId)) continue;
                hasPolicy = true;
            }
            if (hasPolicy) continue;
            Policy associatedPolicy = policyStore.findById(resourceServer, policyId);
            if (associatedPolicy == null && (associatedPolicy = policyStore.findByName(resourceServer, policyId)) == null) {
                throw new RuntimeException("Policy with id or name [" + policyId + "] does not exist");
            }
            policy.addAssociatedPolicy(associatedPolicy);
        }
        for (Policy policyModel : new HashSet<Policy>(policy.getAssociatedPolicies())) {
            hasPolicy = false;
            for (String policyId : policyIds) {
                if (!policyModel.getId().equals(policyId) && !policyModel.getName().equals(policyId)) continue;
                hasPolicy = true;
            }
            if (hasPolicy) continue;
            policy.removeAssociatedPolicy(policyModel);
        }
        policy.removeConfig("applyPolicies");
    }

    private static void updateResources(AbstractPolicyRepresentation representation, Policy policy, AuthorizationProvider authorization) {
        boolean hasResource;
        Set resourceIds = representation.getResources();
        if (resourceIds == null) {
            return;
        }
        StoreFactory storeFactory = authorization.getStoreFactory();
        KeycloakSession session = authorization.getKeycloakSession();
        ResourceServer resourceServer = policy.getResourceServer();
        if (resourceIds.isEmpty()) {
            for (Resource resource : new HashSet<Resource>(policy.getResources())) {
                AdminPermissionsSchema.SCHEMA.removeResource(resource, policy, authorization);
            }
        }
        resourceIds = resourceIds.stream().map(id -> {
            Resource resource = AdminPermissionsSchema.SCHEMA.getOrCreateResource(session, resourceServer, policy.getType(), policy.getResourceType(), (String)id);
            if (resource == null) {
                return id;
            }
            return resource.getId();
        }).collect(Collectors.toSet());
        for (String resourceId : resourceIds) {
            hasResource = false;
            for (Resource resourceModel : new HashSet<Resource>(policy.getResources())) {
                if (!resourceModel.getId().equals(resourceId) && !resourceModel.getName().equals(resourceId)) continue;
                hasResource = true;
            }
            if (hasResource || "".equals(resourceId)) continue;
            Resource resource = storeFactory.getResourceStore().findById(resourceServer, resourceId);
            if (resource == null && (resource = storeFactory.getResourceStore().findByName(resourceServer, resourceId)) == null) {
                throw new RuntimeException("Resource with id or name [" + resourceId + "] does not exist or is not owned by the resource server");
            }
            policy.addResource(resource);
        }
        for (Resource resourceModel : new HashSet<Resource>(policy.getResources())) {
            hasResource = false;
            for (String resourceId : resourceIds) {
                if (!resourceModel.getId().equals(resourceId) && !resourceModel.getName().equals(resourceId)) continue;
                hasResource = true;
            }
            if (hasResource) continue;
            AdminPermissionsSchema.SCHEMA.removeResource(resourceModel, policy, authorization);
        }
        AdminPermissionsSchema.SCHEMA.addUResourceTypeResource(session, resourceServer, policy, representation.getResourceType());
        policy.removeConfig("resources");
    }

    public static Resource toModel(ResourceRepresentation resource, ResourceServer resourceServer, AuthorizationProvider authorization) {
        Map attributes;
        Resource existing;
        String ownerId;
        ResourceStore resourceStore = authorization.getStoreFactory().getResourceStore();
        RealmModel realm = authorization.getRealm();
        ResourceOwnerRepresentation owner = resource.getOwner();
        if (owner == null) {
            owner = new ResourceOwnerRepresentation();
            owner.setId(resourceServer.getClientId());
        }
        if ((ownerId = owner.getId()) == null) {
            ownerId = resourceServer.getClientId();
        }
        if (!resourceServer.getClientId().equals(ownerId)) {
            KeycloakSession keycloakSession = authorization.getKeycloakSession();
            UserProvider users = keycloakSession.users();
            UserModel ownerModel = users.getUserById(realm, ownerId);
            if (ownerModel == null) {
                ownerModel = users.getUserByUsername(realm, ownerId);
            }
            if (ownerModel == null) {
                throw new RuntimeException("Owner must be a valid username or user identifier. If the resource server, the client id or null.");
            }
            ownerId = ownerModel.getId();
        }
        if ((existing = resource.getId() != null ? resourceStore.findById(resourceServer, resource.getId()) : resourceStore.findByName(resourceServer, resource.getName(), ownerId)) != null) {
            existing.setName(resource.getName());
            existing.setDisplayName(resource.getDisplayName());
            existing.setType(resource.getType());
            existing.updateUris(resource.getUris());
            existing.setIconUri(resource.getIconUri());
            existing.setOwnerManagedAccess(Boolean.TRUE.equals(resource.getOwnerManagedAccess()));
            existing.updateScopes(resource.getScopes().stream().map(scope -> RepresentationToModel.toModel(scope, resourceServer, authorization, false)).collect(Collectors.toSet()));
            Map attributes2 = resource.getAttributes();
            if (attributes2 != null) {
                Set<String> existingAttrNames = existing.getAttributes().keySet();
                for (String name : existingAttrNames) {
                    if (attributes2.containsKey(name)) {
                        existing.setAttribute(name, (List)attributes2.get(name));
                        attributes2.remove(name);
                        continue;
                    }
                    existing.removeAttribute(name);
                }
                for (String name : attributes2.keySet()) {
                    existing.setAttribute(name, (List)attributes2.get(name));
                }
            }
            return existing;
        }
        Resource model = resourceStore.create(resourceServer, resource.getId(), resource.getName(), ownerId);
        model.setDisplayName(resource.getDisplayName());
        model.setType(resource.getType());
        model.updateUris(resource.getUris());
        model.setIconUri(resource.getIconUri());
        model.setOwnerManagedAccess(Boolean.TRUE.equals(resource.getOwnerManagedAccess()));
        Set scopes = resource.getScopes();
        if (scopes != null) {
            model.updateScopes(scopes.stream().map(scope -> RepresentationToModel.toModel(scope, resourceServer, authorization, false)).collect(Collectors.toSet()));
        }
        if ((attributes = resource.getAttributes()) != null) {
            for (Map.Entry entry : attributes.entrySet()) {
                model.setAttribute((String)entry.getKey(), (List)entry.getValue());
            }
        }
        resource.setId(model.getId());
        return model;
    }

    public static Scope toModel(ScopeRepresentation scope, ResourceServer resourceServer, AuthorizationProvider authorization) {
        return RepresentationToModel.toModel(scope, resourceServer, authorization, true);
    }

    public static Scope toModel(ScopeRepresentation scope, ResourceServer resourceServer, AuthorizationProvider authorization, boolean updateIfExists) {
        StoreFactory storeFactory = authorization.getStoreFactory();
        ScopeStore scopeStore = storeFactory.getScopeStore();
        Scope existing = scope.getId() != null ? scopeStore.findById(resourceServer, scope.getId()) : scopeStore.findByName(resourceServer, scope.getName());
        if (existing != null) {
            if (updateIfExists) {
                existing.setName(scope.getName());
                existing.setDisplayName(scope.getDisplayName());
                existing.setIconUri(scope.getIconUri());
            }
            return existing;
        }
        Scope model = scopeStore.create(resourceServer, scope.getId(), scope.getName());
        model.setDisplayName(scope.getDisplayName());
        model.setIconUri(scope.getIconUri());
        scope.setId(model.getId());
        return model;
    }

    public static PermissionTicket toModel(PermissionTicketRepresentation representation, ResourceServer resourceServer, AuthorizationProvider authorization) {
        PermissionTicketStore ticketStore = authorization.getStoreFactory().getPermissionTicketStore();
        PermissionTicket ticket = ticketStore.findById(resourceServer, representation.getId());
        boolean granted = representation.isGranted();
        if (granted && !ticket.isGranted()) {
            ticket.setGrantedTimestamp(System.currentTimeMillis());
        } else if (!granted) {
            ticketStore.delete(ticket.getId());
        }
        return ticket;
    }

    public static Map<String, String> removeEmptyString(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, String> m = new HashMap<String, String>(map);
        Iterator itr = m.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            if (e.getValue() != null && !((String)e.getValue()).equals("")) continue;
            itr.remove();
        }
        return m;
    }

    public static ResourceServer createResourceServer(ClientModel client, KeycloakSession session, boolean addDefaultRoles) {
        if ((client.isBearerOnly() || client.isPublicClient()) && !client.getClientId().equals(Config.getAdminRealm() + "-realm") && !client.getClientId().equals("realm-management")) {
            throw new RuntimeException("Only confidential clients are allowed to set authorization settings");
        }
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        UserModel serviceAccount = session.users().getServiceAccount(client);
        if (serviceAccount == null) {
            client.setServiceAccountsEnabled(true);
        }
        if (addDefaultRoles) {
            RoleModel umaProtectionRole = client.getRole("uma_protection");
            if (umaProtectionRole == null) {
                umaProtectionRole = client.addRole("uma_protection");
            }
            if (serviceAccount != null) {
                serviceAccount.grantRole(umaProtectionRole);
            }
        }
        ResourceServerRepresentation representation = new ResourceServerRepresentation();
        representation.setAllowRemoteResourceManagement(true);
        representation.setClientId(client.getId());
        return RepresentationToModel.toModel(representation, authorization, client);
    }

    private static void updateOrganizationBroker(IdentityProviderRepresentation representation, KeycloakSession session) {
        String orgId;
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            return;
        }
        IdentityProviderModel existing = Optional.ofNullable(session.identityProviders().getByAlias(representation.getAlias())).orElse(session.identityProviders().getById(representation.getInternalId()));
        String repOrgId = representation.getOrganizationId() != null ? representation.getOrganizationId() : (String)representation.getConfig().remove("kc.org");
        String string = orgId = existing != null ? existing.getOrganizationId() : repOrgId;
        if (orgId != null) {
            OrganizationProvider provider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
            OrganizationModel org = provider.getById(orgId);
            if (org == null || repOrgId != null && provider.getById(repOrgId) == null) {
                throw new IllegalArgumentException("Organization associated with broker does not exist");
            }
            String domain = (String)representation.getConfig().get("kc.org.domain");
            if (StringUtil.isBlank((String)domain)) {
                representation.getConfig().remove("kc.org.domain");
            } else if (!"ANY".equals(domain)) {
                if (org.getDomains().map(OrganizationDomainModel::getName).noneMatch(domain::equals)) {
                    throw new IllegalArgumentException("Domain does not match any domain from the organization");
                }
            }
            representation.setOrganizationId(orgId);
        }
    }

    public static OrganizationModel toModel(OrganizationRepresentation rep, OrganizationModel model) {
        if (rep == null) {
            return null;
        }
        model.setName(rep.getName());
        model.setAlias(rep.getAlias());
        model.setEnabled(rep.isEnabled());
        model.setRedirectUrl(rep.getRedirectUrl());
        model.setDescription(rep.getDescription());
        model.setAttributes(rep.getAttributes());
        model.setDomains(Optional.ofNullable(rep.getDomains()).orElse(Set.of()).stream().filter(Objects::nonNull).filter(domain -> StringUtil.isNotBlank((String)domain.getName())).map(RepresentationToModel::toModel).collect(Collectors.toSet()));
        return model;
    }

    public static OrganizationDomainModel toModel(OrganizationDomainRepresentation domainRepresentation) {
        return new OrganizationDomainModel(domainRepresentation.getName(), domainRepresentation.isVerified());
    }
}

