/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.migration.migrators.MigrationUtils;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo2_0_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("2.0.0");

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        for (RealmModel realm : session.realms().getRealms()) {
            this.migrateAuthorizationServices(realm);
        }
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateAuthorizationServices(realm);
    }

    private void migrateAuthorizationServices(RealmModel realm) {
        KeycloakModelUtils.setupAuthorizationServices(realm);
        MigrationUtils.addAdminRole(realm, AdminRoles.VIEW_AUTHORIZATION);
        MigrationUtils.addAdminRole(realm, AdminRoles.MANAGE_AUTHORIZATION);
    }
}

