/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.adapter;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.DefaultRoles;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.storage.ReadOnlyException;

public class InMemoryUserAdapter
implements UserModel {
    private String username;
    private Long createdTimestamp = Time.currentTimeMillis();
    private String firstName;
    private String lastName;
    private String email;
    private boolean emailVerified;
    private boolean enabled;
    private String realmId;
    private Set<String> roleIds = new HashSet<String>();
    private Set<String> groupIds = new HashSet<String>();
    private MultivaluedHashMap<String, String> attributes = new MultivaluedHashMap();
    private Set<String> requiredActions = new HashSet<String>();
    private String federationLink;
    private String serviceAccountClientLink;
    private KeycloakSession session;
    private RealmModel realm;
    private String id;
    private boolean readonly;

    public InMemoryUserAdapter(KeycloakSession session, RealmModel realm, String id) {
        this.session = session;
        this.realm = realm;
        this.id = id;
    }

    public void addDefaults() {
        DefaultRoles.addDefaultRoles((RealmModel)this.realm, (UserModel)this);
        for (GroupModel g : this.realm.getDefaultGroups()) {
            this.joinGroup(g);
        }
    }

    public void setReadonly(boolean flag) {
        this.readonly = flag;
    }

    protected void checkReadonly() {
        if (this.readonly) {
            throw new ReadOnlyException("In memory user model is not writable");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.checkReadonly();
        this.username = username.toLowerCase();
    }

    public Long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(Long timestamp) {
        this.checkReadonly();
        this.createdTimestamp = timestamp;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.checkReadonly();
        this.enabled = enabled;
    }

    public void setSingleAttribute(String name, String value) {
        this.checkReadonly();
        this.attributes.putSingle((Object)name, (Object)value);
    }

    public void setAttribute(String name, List<String> values) {
        this.checkReadonly();
        this.attributes.put((Object)name, values);
    }

    public void removeAttribute(String name) {
        this.checkReadonly();
        this.attributes.remove((Object)name);
    }

    public String getFirstAttribute(String name) {
        return (String)this.attributes.getFirst((Object)name);
    }

    public List<String> getAttribute(String name) {
        List value = (List)this.attributes.get((Object)name);
        if (value == null) {
            return new LinkedList<String>();
        }
        return value;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public Set<String> getRequiredActions() {
        return this.requiredActions;
    }

    public void addRequiredAction(String action) {
        this.checkReadonly();
        this.requiredActions.add(action);
    }

    public void removeRequiredAction(String action) {
        this.checkReadonly();
        this.requiredActions.remove(action);
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        this.checkReadonly();
        this.requiredActions.add(action.name());
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.checkReadonly();
        this.requiredActions.remove(action.name());
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.checkReadonly();
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.checkReadonly();
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.checkReadonly();
        if (email != null) {
            email = email.toLowerCase();
        }
        this.email = email;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public void setEmailVerified(boolean verified) {
        this.checkReadonly();
        this.emailVerified = verified;
    }

    public Set<GroupModel> getGroups() {
        if (this.groupIds.size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<GroupModel> groups = new HashSet<GroupModel>();
        for (String id : this.groupIds) {
            groups.add(this.realm.getGroupById(id));
        }
        return groups;
    }

    public void joinGroup(GroupModel group) {
        this.checkReadonly();
        this.groupIds.add(group.getId());
    }

    public void leaveGroup(GroupModel group) {
        this.checkReadonly();
        this.groupIds.remove(group.getId());
    }

    public boolean isMemberOf(GroupModel group) {
        if (this.groupIds == null) {
            return false;
        }
        if (this.groupIds.contains(group.getId())) {
            return true;
        }
        Set<GroupModel> groups = this.getGroups();
        return RoleUtils.isMember(groups, (GroupModel)group);
    }

    public String getFederationLink() {
        return this.federationLink;
    }

    public void setFederationLink(String link) {
        this.checkReadonly();
        this.federationLink = link;
    }

    public String getServiceAccountClientLink() {
        return this.serviceAccountClientLink;
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        this.checkReadonly();
        this.serviceAccountClientLink = clientInternalId;
    }

    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> allRoles = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allRoles) {
            if (!(role.getContainer() instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        Set<RoleModel> roles = this.getRoleMappings();
        for (RoleModel role : roles) {
            if (!app.equals(role.getContainer())) continue;
            result.add(role);
        }
        return result;
    }

    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        return RoleUtils.hasRole(roles, (RoleModel)role) || RoleUtils.hasRoleFromGroup(this.getGroups(), (RoleModel)role, (boolean)true);
    }

    public void grantRole(RoleModel role) {
        this.roleIds.add(role.getId());
    }

    public Set<RoleModel> getRoleMappings() {
        if (this.roleIds.size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String id : this.roleIds) {
            roles.add(this.realm.getRoleById(id));
        }
        return roles;
    }

    public void deleteRoleMapping(RoleModel role) {
        this.roleIds.remove(role.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

