/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.CibaConfig;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuth2DeviceConfig;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.ParConfig;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RequiredActionConfigModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.RealmRepresentation;

public interface RealmModel
extends RoleContainerModel {
    public static final Comparator<RealmModel> COMPARE_BY_NAME = Comparator.comparing(RealmModel::getName);

    @Override
    public String getId();

    public String getName();

    public void setName(String var1);

    public String getDisplayName();

    public void setDisplayName(String var1);

    public String getDisplayNameHtml();

    public void setDisplayNameHtml(String var1);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public SslRequired getSslRequired();

    public void setSslRequired(SslRequired var1);

    public boolean isRegistrationAllowed();

    public void setRegistrationAllowed(boolean var1);

    public boolean isRegistrationEmailAsUsername();

    public void setRegistrationEmailAsUsername(boolean var1);

    public boolean isRememberMe();

    public void setRememberMe(boolean var1);

    public boolean isEditUsernameAllowed();

    public void setEditUsernameAllowed(boolean var1);

    public boolean isUserManagedAccessAllowed();

    public void setUserManagedAccessAllowed(boolean var1);

    public boolean isOrganizationsEnabled();

    public void setOrganizationsEnabled(boolean var1);

    public void setAttribute(String var1, String var2);

    default public void setAttribute(String name, Boolean value) {
        this.setAttribute(name, value.toString());
    }

    default public void setAttribute(String name, Integer value) {
        this.setAttribute(name, value.toString());
    }

    default public void setAttribute(String name, Long value) {
        this.setAttribute(name, value.toString());
    }

    public void removeAttribute(String var1);

    public String getAttribute(String var1);

    default public Integer getAttribute(String name, Integer defaultValue) {
        String v = this.getAttribute(name);
        return v != null && !v.isEmpty() ? Integer.valueOf(v) : defaultValue;
    }

    default public Long getAttribute(String name, Long defaultValue) {
        String v = this.getAttribute(name);
        return v != null && !v.isEmpty() ? Long.valueOf(v) : defaultValue;
    }

    default public Boolean getAttribute(String name, Boolean defaultValue) {
        String v = this.getAttribute(name);
        return v != null && !v.isEmpty() ? Boolean.valueOf(v) : defaultValue;
    }

    public Map<String, String> getAttributes();

    public boolean isBruteForceProtected();

    public void setBruteForceProtected(boolean var1);

    public boolean isPermanentLockout();

    public void setPermanentLockout(boolean var1);

    public int getMaxTemporaryLockouts();

    public void setMaxTemporaryLockouts(int var1);

    public RealmRepresentation.BruteForceStrategy getBruteForceStrategy();

    public void setBruteForceStrategy(RealmRepresentation.BruteForceStrategy var1);

    public int getMaxFailureWaitSeconds();

    public void setMaxFailureWaitSeconds(int var1);

    public int getWaitIncrementSeconds();

    public void setWaitIncrementSeconds(int var1);

    public int getMinimumQuickLoginWaitSeconds();

    public void setMinimumQuickLoginWaitSeconds(int var1);

    public long getQuickLoginCheckMilliSeconds();

    public void setQuickLoginCheckMilliSeconds(long var1);

    public int getMaxDeltaTimeSeconds();

    public void setMaxDeltaTimeSeconds(int var1);

    public int getFailureFactor();

    public void setFailureFactor(int var1);

    public boolean isVerifyEmail();

    public void setVerifyEmail(boolean var1);

    public boolean isLoginWithEmailAllowed();

    public void setLoginWithEmailAllowed(boolean var1);

    public boolean isDuplicateEmailsAllowed();

    public void setDuplicateEmailsAllowed(boolean var1);

    public boolean isResetPasswordAllowed();

    public void setResetPasswordAllowed(boolean var1);

    public String getDefaultSignatureAlgorithm();

    public void setDefaultSignatureAlgorithm(String var1);

    public boolean isRevokeRefreshToken();

    public void setRevokeRefreshToken(boolean var1);

    public int getRefreshTokenMaxReuse();

    public void setRefreshTokenMaxReuse(int var1);

    public int getSsoSessionIdleTimeout();

    public void setSsoSessionIdleTimeout(int var1);

    public int getSsoSessionMaxLifespan();

    public void setSsoSessionMaxLifespan(int var1);

    public int getSsoSessionIdleTimeoutRememberMe();

    public void setSsoSessionIdleTimeoutRememberMe(int var1);

    public int getSsoSessionMaxLifespanRememberMe();

    public void setSsoSessionMaxLifespanRememberMe(int var1);

    public int getOfflineSessionIdleTimeout();

    public void setOfflineSessionIdleTimeout(int var1);

    public int getAccessTokenLifespan();

    public boolean isOfflineSessionMaxLifespanEnabled();

    public void setOfflineSessionMaxLifespanEnabled(boolean var1);

    public int getOfflineSessionMaxLifespan();

    public void setOfflineSessionMaxLifespan(int var1);

    public int getClientSessionIdleTimeout();

    public void setClientSessionIdleTimeout(int var1);

    public int getClientSessionMaxLifespan();

    public void setClientSessionMaxLifespan(int var1);

    public int getClientOfflineSessionIdleTimeout();

    public void setClientOfflineSessionIdleTimeout(int var1);

    public int getClientOfflineSessionMaxLifespan();

    public void setClientOfflineSessionMaxLifespan(int var1);

    public void setAccessTokenLifespan(int var1);

    public int getAccessTokenLifespanForImplicitFlow();

    public void setAccessTokenLifespanForImplicitFlow(int var1);

    public int getAccessCodeLifespan();

    public void setAccessCodeLifespan(int var1);

    public int getAccessCodeLifespanUserAction();

    public void setAccessCodeLifespanUserAction(int var1);

    public OAuth2DeviceConfig getOAuth2DeviceConfig();

    public CibaConfig getCibaPolicy();

    public ParConfig getParPolicy();

    public Map<String, Integer> getUserActionTokenLifespans();

    public int getAccessCodeLifespanLogin();

    public void setAccessCodeLifespanLogin(int var1);

    public int getActionTokenGeneratedByAdminLifespan();

    public void setActionTokenGeneratedByAdminLifespan(int var1);

    public int getActionTokenGeneratedByUserLifespan();

    public void setActionTokenGeneratedByUserLifespan(int var1);

    public int getActionTokenGeneratedByUserLifespan(String var1);

    public void setActionTokenGeneratedByUserLifespan(String var1, Integer var2);

    public Stream<RequiredCredentialModel> getRequiredCredentialsStream();

    public void addRequiredCredential(String var1);

    public PasswordPolicy getPasswordPolicy();

    public void setPasswordPolicy(PasswordPolicy var1);

    public OTPPolicy getOTPPolicy();

    public void setOTPPolicy(OTPPolicy var1);

    public WebAuthnPolicy getWebAuthnPolicy();

    public void setWebAuthnPolicy(WebAuthnPolicy var1);

    public WebAuthnPolicy getWebAuthnPolicyPasswordless();

    public void setWebAuthnPolicyPasswordless(WebAuthnPolicy var1);

    public RoleModel getRoleById(String var1);

    public Stream<GroupModel> getDefaultGroupsStream();

    public void addDefaultGroup(GroupModel var1);

    public void removeDefaultGroup(GroupModel var1);

    public Stream<ClientModel> getClientsStream();

    public Stream<ClientModel> getClientsStream(Integer var1, Integer var2);

    public Long getClientsCount();

    public Stream<ClientModel> getAlwaysDisplayInConsoleClientsStream();

    public ClientModel addClient(String var1);

    public ClientModel addClient(String var1, String var2);

    public boolean removeClient(String var1);

    public ClientModel getClientById(String var1);

    public ClientModel getClientByClientId(String var1);

    public Stream<ClientModel> searchClientByClientIdStream(String var1, Integer var2, Integer var3);

    public Stream<ClientModel> searchClientByAttributes(Map<String, String> var1, Integer var2, Integer var3);

    public Stream<ClientModel> searchClientByAuthenticationFlowBindingOverrides(Map<String, String> var1, Integer var2, Integer var3);

    public void updateRequiredCredentials(Set<String> var1);

    public Map<String, String> getBrowserSecurityHeaders();

    public void setBrowserSecurityHeaders(Map<String, String> var1);

    public Map<String, String> getSmtpConfig();

    public void setSmtpConfig(Map<String, String> var1);

    public AuthenticationFlowModel getBrowserFlow();

    public void setBrowserFlow(AuthenticationFlowModel var1);

    public AuthenticationFlowModel getRegistrationFlow();

    public void setRegistrationFlow(AuthenticationFlowModel var1);

    public AuthenticationFlowModel getDirectGrantFlow();

    public void setDirectGrantFlow(AuthenticationFlowModel var1);

    public AuthenticationFlowModel getResetCredentialsFlow();

    public void setResetCredentialsFlow(AuthenticationFlowModel var1);

    public AuthenticationFlowModel getClientAuthenticationFlow();

    public void setClientAuthenticationFlow(AuthenticationFlowModel var1);

    public AuthenticationFlowModel getDockerAuthenticationFlow();

    public void setDockerAuthenticationFlow(AuthenticationFlowModel var1);

    public AuthenticationFlowModel getFirstBrokerLoginFlow();

    public void setFirstBrokerLoginFlow(AuthenticationFlowModel var1);

    public Stream<AuthenticationFlowModel> getAuthenticationFlowsStream();

    public AuthenticationFlowModel getFlowByAlias(String var1);

    public AuthenticationFlowModel addAuthenticationFlow(AuthenticationFlowModel var1);

    public AuthenticationFlowModel getAuthenticationFlowById(String var1);

    public void removeAuthenticationFlow(AuthenticationFlowModel var1);

    public void updateAuthenticationFlow(AuthenticationFlowModel var1);

    public Stream<AuthenticationExecutionModel> getAuthenticationExecutionsStream(String var1);

    public AuthenticationExecutionModel getAuthenticationExecutionById(String var1);

    public AuthenticationExecutionModel getAuthenticationExecutionByFlowId(String var1);

    public AuthenticationExecutionModel addAuthenticatorExecution(AuthenticationExecutionModel var1);

    public void updateAuthenticatorExecution(AuthenticationExecutionModel var1);

    public void removeAuthenticatorExecution(AuthenticationExecutionModel var1);

    public Stream<AuthenticatorConfigModel> getAuthenticatorConfigsStream();

    public AuthenticatorConfigModel addAuthenticatorConfig(AuthenticatorConfigModel var1);

    public void updateAuthenticatorConfig(AuthenticatorConfigModel var1);

    public void removeAuthenticatorConfig(AuthenticatorConfigModel var1);

    public AuthenticatorConfigModel getAuthenticatorConfigById(String var1);

    public AuthenticatorConfigModel getAuthenticatorConfigByAlias(String var1);

    public RequiredActionConfigModel getRequiredActionConfigById(String var1);

    public RequiredActionConfigModel getRequiredActionConfigByAlias(String var1);

    public void removeRequiredActionProviderConfig(RequiredActionConfigModel var1);

    public void updateRequiredActionConfig(RequiredActionConfigModel var1);

    public Stream<RequiredActionConfigModel> getRequiredActionConfigsStream();

    public Stream<RequiredActionProviderModel> getRequiredActionProvidersStream();

    public RequiredActionProviderModel addRequiredActionProvider(RequiredActionProviderModel var1);

    public void updateRequiredActionProvider(RequiredActionProviderModel var1);

    public void removeRequiredActionProvider(RequiredActionProviderModel var1);

    public RequiredActionProviderModel getRequiredActionProviderById(String var1);

    public RequiredActionProviderModel getRequiredActionProviderByAlias(String var1);

    @Deprecated
    public Stream<IdentityProviderModel> getIdentityProvidersStream();

    @Deprecated
    public IdentityProviderModel getIdentityProviderByAlias(String var1);

    @Deprecated
    public void addIdentityProvider(IdentityProviderModel var1);

    @Deprecated
    public void removeIdentityProviderByAlias(String var1);

    @Deprecated
    public void updateIdentityProvider(IdentityProviderModel var1);

    @Deprecated
    public Stream<IdentityProviderMapperModel> getIdentityProviderMappersStream();

    @Deprecated
    public Stream<IdentityProviderMapperModel> getIdentityProviderMappersByAliasStream(String var1);

    @Deprecated
    public IdentityProviderMapperModel addIdentityProviderMapper(IdentityProviderMapperModel var1);

    @Deprecated
    public void removeIdentityProviderMapper(IdentityProviderMapperModel var1);

    @Deprecated
    public void updateIdentityProviderMapper(IdentityProviderMapperModel var1);

    @Deprecated
    public IdentityProviderMapperModel getIdentityProviderMapperById(String var1);

    @Deprecated
    public IdentityProviderMapperModel getIdentityProviderMapperByName(String var1, String var2);

    public ComponentModel addComponentModel(ComponentModel var1);

    public ComponentModel importComponentModel(ComponentModel var1);

    public void updateComponent(ComponentModel var1);

    public void removeComponent(ComponentModel var1);

    public void removeComponents(String var1);

    public Stream<ComponentModel> getComponentsStream(String var1, String var2);

    public Stream<ComponentModel> getComponentsStream(String var1);

    public Stream<ComponentModel> getComponentsStream();

    public ComponentModel getComponent(String var1);

    default public Stream<ComponentModel> getStorageProviders(Class<? extends Provider> storageProviderClass) {
        return this.getComponentsStream(this.getId(), storageProviderClass.getName());
    }

    public String getLoginTheme();

    public void setLoginTheme(String var1);

    public String getAccountTheme();

    public void setAccountTheme(String var1);

    public String getAdminTheme();

    public void setAdminTheme(String var1);

    public String getEmailTheme();

    public void setEmailTheme(String var1);

    public int getNotBefore();

    public void setNotBefore(int var1);

    public boolean isEventsEnabled();

    public void setEventsEnabled(boolean var1);

    public long getEventsExpiration();

    public void setEventsExpiration(long var1);

    public Stream<String> getEventsListenersStream();

    public void setEventsListeners(Set<String> var1);

    public Stream<String> getEnabledEventTypesStream();

    public void setEnabledEventTypes(Set<String> var1);

    public boolean isAdminEventsEnabled();

    public void setAdminEventsEnabled(boolean var1);

    public boolean isAdminEventsDetailsEnabled();

    public void setAdminEventsDetailsEnabled(boolean var1);

    public ClientModel getMasterAdminClient();

    public void setMasterAdminClient(ClientModel var1);

    public RoleModel getDefaultRole();

    public void setDefaultRole(RoleModel var1);

    @Deprecated
    public boolean isIdentityFederationEnabled();

    public boolean isInternationalizationEnabled();

    public void setInternationalizationEnabled(boolean var1);

    public Stream<String> getSupportedLocalesStream();

    public void setSupportedLocales(Set<String> var1);

    public String getDefaultLocale();

    public void setDefaultLocale(String var1);

    default public GroupModel createGroup(String name) {
        return this.createGroup(null, name, null);
    }

    default public GroupModel createGroup(String id, String name) {
        return this.createGroup(id, name, null);
    }

    default public GroupModel createGroup(String name, GroupModel toParent) {
        return this.createGroup(null, name, toParent);
    }

    public GroupModel createGroup(String var1, String var2, GroupModel var3);

    public GroupModel getGroupById(String var1);

    public Stream<GroupModel> getGroupsStream();

    public Long getGroupsCount(Boolean var1);

    public Long getGroupsCountByNameContaining(String var1);

    @Deprecated
    public Stream<GroupModel> getTopLevelGroupsStream();

    @Deprecated
    public Stream<GroupModel> getTopLevelGroupsStream(Integer var1, Integer var2);

    public boolean removeGroup(GroupModel var1);

    public void moveGroup(GroupModel var1, GroupModel var2);

    public Stream<ClientScopeModel> getClientScopesStream();

    public ClientScopeModel addClientScope(String var1);

    public ClientScopeModel addClientScope(String var1, String var2);

    public boolean removeClientScope(String var1);

    public ClientScopeModel getClientScopeById(String var1);

    public void addDefaultClientScope(ClientScopeModel var1, boolean var2);

    public void removeDefaultClientScope(ClientScopeModel var1);

    public void createOrUpdateRealmLocalizationTexts(String var1, Map<String, String> var2);

    public boolean removeRealmLocalizationTexts(String var1);

    public Map<String, Map<String, String>> getRealmLocalizationTexts();

    public Map<String, String> getRealmLocalizationTextsByLocale(String var1);

    public Stream<ClientScopeModel> getDefaultClientScopesStream(boolean var1);

    default public void addToDefaultRoles(RoleModel role) {
        this.getDefaultRole().addCompositeRole(role);
    }

    public ClientInitialAccessModel createClientInitialAccessModel(int var1, int var2);

    public ClientInitialAccessModel getClientInitialAccessModel(String var1);

    public void removeClientInitialAccessModel(String var1);

    public Stream<ClientInitialAccessModel> getClientInitialAccesses();

    public void decreaseRemainingCount(ClientInitialAccessModel var1);

    public static interface IdentityProviderRemovedEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public IdentityProviderModel getRemovedIdentityProvider();

        public KeycloakSession getKeycloakSession();
    }

    public static interface IdentityProviderUpdatedEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public IdentityProviderModel getUpdatedIdentityProvider();

        public KeycloakSession getKeycloakSession();
    }

    public static interface RealmRemovedEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public KeycloakSession getKeycloakSession();
    }

    public static interface RealmPostCreateEvent
    extends ProviderEvent {
        public RealmModel getCreatedRealm();

        public KeycloakSession getKeycloakSession();
    }

    public static interface RealmCreationEvent
    extends ProviderEvent {
        public RealmModel getCreatedRealm();

        public KeycloakSession getKeycloakSession();
    }
}

