/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormAuthenticator;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.deployment.DeployedConfigurationsManager;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionConfigModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.utils.Base32;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigInfoRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.RequiredActionConfigInfoRepresentation;
import org.keycloak.representations.idm.RequiredActionConfigRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.userprofile.ValidationException;
import org.keycloak.utils.CredentialHelper;
import org.keycloak.utils.RequiredActionHelper;
import org.keycloak.utils.ReservedCharValidator;

@Extension(name="x-smallrye-profile-admin", value="")
public class AuthenticationManagementResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    protected static final Logger logger = Logger.getLogger(AuthenticationManagementResource.class);

    public AuthenticationManagementResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.AUTH_FLOW);
    }

    @Path(value="/form-providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Get form providers Returns a stream of form providers.")
    public Stream<Map<String, Object>> getFormProviders() {
        this.auth.realm().requireViewRealm();
        return this.buildProviderMetadata(this.session.getKeycloakSessionFactory().getProviderFactoriesStream(FormAuthenticator.class));
    }

    @Path(value="/authenticator-providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Get authenticator providers Returns a stream of authenticator providers.")
    public Stream<Map<String, Object>> getAuthenticatorProviders() {
        this.auth.realm().requireViewRealm();
        return this.buildProviderMetadata(this.session.getKeycloakSessionFactory().getProviderFactoriesStream(Authenticator.class));
    }

    @Path(value="/client-authenticator-providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Get client authenticator providers Returns a stream of client authenticator providers.")
    public Stream<Map<String, Object>> getClientAuthenticatorProviders() {
        this.auth.realm().requireViewClientAuthenticatorProviders();
        Stream factories = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(ClientAuthenticator.class);
        return factories.map(factory -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            this.buildProviderMetadataHelper((Map<String, Object>)data, (ProviderFactory)factory);
            data.put("supportsSecret", ((ClientAuthenticatorFactory)factory).supportsSecret());
            return data;
        });
    }

    private void buildProviderMetadataHelper(Map<String, Object> data, ProviderFactory factory) {
        data.put("id", factory.getId());
        ConfigurableAuthenticatorFactory configured = (ConfigurableAuthenticatorFactory)factory;
        data.put("description", configured.getHelpText());
        data.put("displayName", configured.getDisplayType());
    }

    public Stream<Map<String, Object>> buildProviderMetadata(Stream<ProviderFactory> factories) {
        return factories.map(factory -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            this.buildProviderMetadataHelper((Map<String, Object>)data, (ProviderFactory)factory);
            return data;
        });
    }

    @Path(value="/form-action-providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Get form action providers Returns a stream of form action providers.")
    public Stream<Map<String, Object>> getFormActionProviders() {
        this.auth.realm().requireViewRealm();
        return this.buildProviderMetadata(this.session.getKeycloakSessionFactory().getProviderFactoriesStream(FormAction.class));
    }

    @Path(value="/flows")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Get authentication flows Returns a stream of authentication flows.")
    public Stream<AuthenticationFlowRepresentation> getFlows() {
        this.auth.realm().requireViewAuthenticationFlows();
        return this.realm.getAuthenticationFlowsStream().filter(flow -> flow.isTopLevel() && !Objects.equals(flow.getAlias(), "saml ecp")).map(flow -> ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (AuthenticationFlowModel)flow));
    }

    @Path(value="/flows")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Create a new authentication flow")
    @APIResponse(responseCode="201", description="Created")
    public Response createFlow(@Parameter(description="Authentication flow representation") AuthenticationFlowRepresentation flow) {
        this.auth.realm().requireManageRealm();
        if (flow.getAlias() == null || flow.getAlias().isEmpty()) {
            throw ErrorResponse.exists("Failed to create flow with empty alias name");
        }
        if (this.realm.getFlowByAlias(flow.getAlias()) != null) {
            throw ErrorResponse.exists("Flow " + flow.getAlias() + " already exists");
        }
        if (Objects.isNull(flow.getDescription())) {
            flow.setDescription("");
        }
        ReservedCharValidator.validate((String)flow.getAlias());
        AuthenticationFlowModel createdModel = this.realm.addAuthenticationFlow(RepresentationToModel.toModel((AuthenticationFlowRepresentation)flow));
        flow.setId(createdModel.getId());
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), createdModel.getId()).representation(flow).success();
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(flow.getId()).build(new Object[0])).build();
    }

    @Path(value="/flows/{id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Get authentication flow for id")
    public AuthenticationFlowRepresentation getFlow(@Parameter(description="Flow id") @PathParam(value="id") String id) {
        this.auth.realm().requireViewRealm();
        AuthenticationFlowModel flow = this.realm.getAuthenticationFlowById(id);
        if (flow == null) {
            throw new NotFoundException("Could not find flow with id");
        }
        return ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (AuthenticationFlowModel)flow);
    }

    @Path(value="/flows/{id}")
    @PUT
    @NoCache
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Update an authentication flow")
    @APIResponse(responseCode="204", description="No Content")
    public void updateFlow(@PathParam(value="id") String id, AuthenticationFlowRepresentation flow) {
        this.auth.realm().requireManageRealm();
        AuthenticationFlowRepresentation existingFlow = this.getFlow(id);
        if (flow.getAlias() == null || flow.getAlias().isEmpty()) {
            throw ErrorResponse.exists("Failed to update flow with empty alias name");
        }
        ReservedCharValidator.validate((String)flow.getAlias());
        AuthenticationFlowModel checkFlow = this.realm.getAuthenticationFlowById(id);
        if (checkFlow == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        if (this.realm.getFlowByAlias(flow.getAlias()) != null && !checkFlow.getAlias().equals(flow.getAlias())) {
            throw ErrorResponse.exists("Flow alias name already exists");
        }
        if (checkFlow.getAlias() != null && !checkFlow.getAlias().equals(flow.getAlias())) {
            checkFlow.setAlias(flow.getAlias());
        } else if (checkFlow.getAlias() == null && flow.getAlias() != null) {
            checkFlow.setAlias(flow.getAlias());
        }
        if (checkFlow.getDescription() != null && !checkFlow.getDescription().equals(flow.getDescription())) {
            checkFlow.setDescription(flow.getDescription());
        } else if (checkFlow.getDescription() == null && flow.getDescription() != null) {
            checkFlow.setDescription(flow.getDescription());
        }
        flow.setId(existingFlow.getId());
        this.realm.updateAuthenticationFlow(RepresentationToModel.toModel((AuthenticationFlowRepresentation)flow));
        this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(flow).success();
    }

    @Path(value="/flows/{id}")
    @DELETE
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Delete an authentication flow")
    @APIResponse(responseCode="204", description="No Content")
    public void deleteFlow(@Parameter(description="Flow id") @PathParam(value="id") String id) {
        this.auth.realm().requireManageRealm();
        AuthenticationFlowModel flow = this.realm.getAuthenticationFlowById(id);
        if (flow == null) {
            throw new NotFoundException("Flow not found");
        }
        KeycloakModelUtils.deepDeleteAuthenticationFlow((KeycloakSession)this.session, (RealmModel)this.realm, (AuthenticationFlowModel)flow, () -> {}, () -> {
            throw new BadRequestException("Can't delete built in flow");
        });
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="/flows/{flowAlias}/copy")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Copy existing authentication flow under a new name The new name is given as 'newName' attribute of the passed JSON object")
    @APIResponse(responseCode="201", description="Created")
    public Response copy(@Parameter(description="name of the existing authentication flow") @PathParam(value="flowAlias") String flowAlias, Map<String, String> data) {
        this.auth.realm().requireManageRealm();
        String newName = data.get("newName");
        if (this.realm.getFlowByAlias(newName) != null) {
            throw ErrorResponse.exists("New flow alias name already exists");
        }
        AuthenticationFlowModel flow = this.realm.getFlowByAlias(flowAlias);
        if (flow == null) {
            logger.debug((Object)("flow not found: " + flowAlias));
            throw new NotFoundException("Flow not found");
        }
        AuthenticationFlowModel copy = AuthenticationManagementResource.copyFlow(this.session, this.realm, flow, newName);
        data.put("id", copy.getId());
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(data).success();
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    public static AuthenticationFlowModel copyFlow(KeycloakSession session, RealmModel realm, AuthenticationFlowModel flow, String newName) {
        AuthenticationFlowModel copy = new AuthenticationFlowModel();
        copy.setAlias(newName);
        copy.setDescription(flow.getDescription());
        copy.setProviderId(flow.getProviderId());
        copy.setBuiltIn(false);
        copy.setTopLevel(flow.isTopLevel());
        copy = realm.addAuthenticationFlow(copy);
        AuthenticationManagementResource.copy(session, realm, newName, flow, copy);
        return copy;
    }

    public static void copy(KeycloakSession session, RealmModel realm, String newName, AuthenticationFlowModel from, AuthenticationFlowModel to) {
        realm.getAuthenticationExecutionsStream(from.getId()).forEachOrdered(execution -> {
            if (execution.isAuthenticatorFlow()) {
                AuthenticationFlowModel subFlow = realm.getAuthenticationFlowById(execution.getFlowId());
                AuthenticationFlowModel copy = new AuthenticationFlowModel();
                copy.setAlias(newName + " " + subFlow.getAlias());
                copy.setDescription(subFlow.getDescription());
                copy.setProviderId(subFlow.getProviderId());
                copy.setBuiltIn(false);
                copy.setTopLevel(false);
                copy = realm.addAuthenticationFlow(copy);
                execution.setFlowId(copy.getId());
                AuthenticationManagementResource.copy(session, realm, newName, subFlow, copy);
            }
            if (execution.getAuthenticatorConfig() != null) {
                DeployedConfigurationsManager configManager = new DeployedConfigurationsManager(session);
                AuthenticatorConfigModel config = configManager.getAuthenticatorConfig(realm, execution.getAuthenticatorConfig());
                if (config == null) {
                    logger.debugf("Authentication execution configuration with id [%s] not found", (Object)execution.getAuthenticatorConfig());
                    throw new IllegalStateException("Authentication execution configuration not found");
                }
                if (configManager.getDeployedAuthenticatorConfig(execution.getAuthenticatorConfig()) != null) {
                    execution.setAuthenticatorConfig(config.getId());
                } else {
                    config.setId(null);
                    if (config.getAlias() != null) {
                        config.setAlias(newName + " " + config.getAlias());
                    }
                    AuthenticatorConfigModel newConfig = realm.addAuthenticatorConfig(config);
                    execution.setAuthenticatorConfig(newConfig.getId());
                }
            }
            execution.setId(null);
            execution.setParentFlow(to.getId());
            realm.addAuthenticatorExecution(execution);
        });
    }

    @Path(value="/flows/{flowAlias}/executions/flow")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Add new flow with new execution to existing flow")
    @APIResponse(responseCode="201", description="Created")
    public Response addExecutionFlow(@Parameter(description="Alias of parent authentication flow") @PathParam(value="flowAlias") String flowAlias, @Parameter(description="New authentication flow / execution JSON data containing 'alias', 'type', 'provider', 'priority', and 'description' attributes") Map<String, Object> data) {
        this.auth.realm().requireManageRealm();
        AuthenticationFlowModel parentFlow = this.realm.getFlowByAlias(flowAlias);
        if (parentFlow == null) {
            throw ErrorResponse.error("Parent flow doesn't exist", Response.Status.BAD_REQUEST);
        }
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to add sub-flow to a built in flow");
        }
        String alias = (String)data.get("alias");
        String type = (String)data.get("type");
        String provider = (String)data.get("provider");
        int priority = data.containsKey("priority") ? ((Integer)data.get("priority")).intValue() : this.getNextPriority(parentFlow);
        String description = Objects.isNull(data.get("description")) ? "" : (String)data.get("description");
        AuthenticationFlowModel newFlow = this.realm.getFlowByAlias(alias);
        if (newFlow != null) {
            throw ErrorResponse.exists("New flow alias name already exists");
        }
        newFlow = new AuthenticationFlowModel();
        newFlow.setAlias(alias);
        newFlow.setDescription(description);
        newFlow.setProviderId(type);
        newFlow = this.realm.addAuthenticationFlow(newFlow);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlow.getId());
        execution.setFlowId(newFlow.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED);
        execution.setAuthenticatorFlow(true);
        if (type.equals("form-flow")) {
            execution.setAuthenticator(provider);
        }
        execution.setPriority(priority);
        execution = this.realm.addAuthenticatorExecution(execution);
        data.put("id", execution.getId());
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.AUTH_EXECUTION_FLOW).resourcePath((UriInfo)this.session.getContext().getUri()).representation(data).success();
        String addExecutionPathSegment = UriBuilder.fromMethod(AuthenticationManagementResource.class, (String)"addExecutionFlow").build(new Object[]{parentFlow.getAlias()}).getPath();
        return Response.created((URI)this.session.getContext().getUri().getBaseUriBuilder().path(this.session.getContext().getUri().getPath().replace(addExecutionPathSegment, "")).path("flows").path(newFlow.getId()).build(new Object[0])).build();
    }

    private int getNextPriority(AuthenticationFlowModel parentFlow) {
        List executions = this.realm.getAuthenticationExecutionsStream(parentFlow.getId()).collect(Collectors.toList());
        return executions.isEmpty() ? 0 : ((AuthenticationExecutionModel)executions.get(executions.size() - 1)).getPriority() + 1;
    }

    @Path(value="/flows/{flowAlias}/executions/execution")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Add new authentication execution to a flow")
    @APIResponse(responseCode="201", description="Created")
    public Response addExecutionToFlow(@Parameter(description="Alias of parent flow") @PathParam(value="flowAlias") String flowAlias, @Parameter(description="New execution JSON data containing 'provider' and 'priority' (optional) attribute") Map<String, Object> data) {
        this.auth.realm().requireManageRealm();
        AuthenticationFlowModel parentFlow = this.realm.getFlowByAlias(flowAlias);
        if (parentFlow == null) {
            throw new BadRequestException("Parent flow doesn't exist");
        }
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to add execution to a built in flow");
        }
        String provider = (String)data.get("provider");
        int priority = data.containsKey("priority") ? ((Integer)data.get("priority")).intValue() : this.getNextPriority(parentFlow);
        ProviderFactory f = this.getProviderFactory(parentFlow, provider);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlow.getId());
        ConfigurableAuthenticatorFactory conf = (ConfigurableAuthenticatorFactory)f;
        if (conf.getRequirementChoices().length == 1) {
            execution.setRequirement(conf.getRequirementChoices()[0]);
        } else {
            execution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED);
        }
        execution.setAuthenticatorFlow(false);
        execution.setAuthenticator(provider);
        execution.setPriority(priority);
        execution = this.realm.addAuthenticatorExecution(execution);
        this.checkConfigForDeployedProvider(f, execution);
        data.put("id", execution.getId());
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(data).success();
        String addExecutionPathSegment = UriBuilder.fromMethod(AuthenticationManagementResource.class, (String)"addExecutionToFlow").build(new Object[]{parentFlow.getAlias()}).getPath();
        return Response.created((URI)this.session.getContext().getUri().getBaseUriBuilder().path(this.session.getContext().getUri().getPath().replace(addExecutionPathSegment, "")).path("executions").path(execution.getId()).build(new Object[0])).build();
    }

    private ProviderFactory getProviderFactory(AuthenticationFlowModel parentFlow, String provider) {
        ProviderFactory f = null;
        f = parentFlow.getProviderId().equals("client-flow") ? this.session.getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, provider) : (parentFlow.getProviderId().equals("form-flow") ? this.session.getKeycloakSessionFactory().getProviderFactory(FormAction.class, provider) : this.session.getKeycloakSessionFactory().getProviderFactory(Authenticator.class, provider));
        if (f == null) {
            throw new BadRequestException("No authentication provider found for id: " + provider);
        }
        return f;
    }

    private void checkConfigForDeployedProvider(ProviderFactory f, AuthenticationExecutionModel execution) {
        ConfiguredProvider internalProviderFactory;
        AuthenticatorConfigModel config;
        if (f instanceof ConfiguredProvider && (config = (AuthenticatorConfigModel)(internalProviderFactory = (ConfiguredProvider)f).getConfig()) != null) {
            logger.tracef("Updating execution of provider '%s' with shared configuration.", (Object)execution.getAuthenticator());
            execution.setAuthenticatorConfig(config.getId());
            this.realm.updateAuthenticatorExecution(execution);
        }
    }

    @Path(value="/flows/{flowAlias}/executions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Get authentication executions for a flow")
    public List<AuthenticationExecutionInfoRepresentation> getExecutions(@Parameter(description="Flow alias") @PathParam(value="flowAlias") String flowAlias) {
        this.auth.realm().requireViewRealm();
        AuthenticationFlowModel flow = this.realm.getFlowByAlias(flowAlias);
        if (flow == null) {
            logger.debug((Object)("flow not found: " + flowAlias));
            throw new NotFoundException("Flow not found");
        }
        LinkedList<AuthenticationExecutionInfoRepresentation> result = new LinkedList<AuthenticationExecutionInfoRepresentation>();
        int level = 0;
        this.recurseExecutions(flow, result, level);
        return result;
    }

    public void recurseExecutions(AuthenticationFlowModel flow, List<AuthenticationExecutionInfoRepresentation> result, int level) {
        AtomicInteger index = new AtomicInteger(0);
        this.realm.getAuthenticationExecutionsStream(flow.getId()).forEachOrdered(execution -> {
            AuthenticationExecutionInfoRepresentation rep = new AuthenticationExecutionInfoRepresentation();
            rep.setLevel(level);
            rep.setIndex(index.getAndIncrement());
            rep.setRequirementChoices(new LinkedList());
            rep.setPriority(execution.getPriority());
            if (execution.isAuthenticatorFlow()) {
                AuthenticationFlowModel flowRef = this.realm.getAuthenticationFlowById(execution.getFlowId());
                if ("basic-flow".equals(flowRef.getProviderId())) {
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.REQUIRED.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.ALTERNATIVE.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.DISABLED.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.CONDITIONAL.name());
                } else if ("form-flow".equals(flowRef.getProviderId())) {
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.REQUIRED.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.DISABLED.name());
                    rep.setProviderId(execution.getAuthenticator());
                    rep.setAuthenticationConfig(execution.getAuthenticatorConfig());
                } else if ("client-flow".equals(flowRef.getProviderId())) {
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.ALTERNATIVE.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.REQUIRED.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.DISABLED.name());
                }
                rep.setDisplayName(flowRef.getAlias());
                rep.setDescription(flowRef.getDescription());
                rep.setConfigurable(Boolean.valueOf(false));
                rep.setId(execution.getId());
                rep.setAuthenticationFlow(Boolean.valueOf(execution.isAuthenticatorFlow()));
                rep.setRequirement(execution.getRequirement().name());
                rep.setFlowId(execution.getFlowId());
                result.add(rep);
                this.recurseExecutions(flowRef, result, level + 1);
            } else {
                AuthenticatorConfigModel authenticatorConfig;
                String authenticatorConfigId;
                String providerId = execution.getAuthenticator();
                ConfigurableAuthenticatorFactory factory = CredentialHelper.getConfigurableAuthenticatorFactory((KeycloakSession)this.session, (String)providerId);
                if (factory == null) {
                    logger.warnf("Cannot find authentication provider implementation with provider ID '%s'", (Object)providerId);
                    throw new NotFoundException("Could not find authenticator provider");
                }
                rep.setDisplayName(factory.getDisplayType());
                rep.setConfigurable(Boolean.valueOf(factory.isConfigurable()));
                for (AuthenticationExecutionModel.Requirement choice : factory.getRequirementChoices()) {
                    rep.getRequirementChoices().add(choice.name());
                }
                rep.setId(execution.getId());
                if (factory.isConfigurable() && (authenticatorConfigId = execution.getAuthenticatorConfig()) != null && (authenticatorConfig = new DeployedConfigurationsManager(this.session).getAuthenticatorConfig(this.realm, authenticatorConfigId)) != null) {
                    rep.setAlias(authenticatorConfig.getAlias());
                }
                rep.setRequirement(execution.getRequirement().name());
                providerId = execution.getAuthenticator();
                if (providerId.startsWith("script-")) {
                    providerId = Base32.encode((byte[])providerId.getBytes());
                }
                rep.setProviderId(providerId);
                rep.setAuthenticationConfig(execution.getAuthenticatorConfig());
                result.add(rep);
            }
        });
    }

    @Path(value="/flows/{flowAlias}/executions")
    @PUT
    @NoCache
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Update authentication executions of a Flow")
    @APIResponse(responseCode="204", description="No Content")
    public void updateExecutions(@Parameter(description="Flow alias") @PathParam(value="flowAlias") String flowAlias, @Parameter(description="AuthenticationExecutionInfoRepresentation") AuthenticationExecutionInfoRepresentation rep) {
        this.auth.realm().requireManageRealm();
        AuthenticationFlowModel flow = this.realm.getFlowByAlias(flowAlias);
        if (flow == null) {
            logger.debug((Object)("flow not found: " + flowAlias));
            throw new NotFoundException("flow not found");
        }
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(rep.getId());
        if (model == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        boolean updateExecution = false;
        if (model.getPriority() != rep.getPriority()) {
            model.setPriority(rep.getPriority());
            updateExecution = true;
        }
        if (!model.getRequirement().name().equals(rep.getRequirement())) {
            model.setRequirement(AuthenticationExecutionModel.Requirement.valueOf((String)rep.getRequirement()));
            updateExecution = true;
        }
        if (updateExecution) {
            this.realm.updateAuthenticatorExecution(model);
            this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
            return;
        }
        if (rep.getAuthenticationFlow() == null) {
            return;
        }
        AuthenticationFlowModel checkFlow = this.realm.getAuthenticationFlowById(rep.getFlowId());
        if (checkFlow == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        if (this.realm.getFlowByAlias(rep.getDisplayName()) != null && !checkFlow.getAlias().equals(rep.getDisplayName())) {
            throw ErrorResponse.exists("Flow alias name already exists");
        }
        if (!checkFlow.getAlias().equals(rep.getDisplayName())) {
            checkFlow.setAlias(rep.getDisplayName());
        }
        if (Objects.isNull(checkFlow.getDescription())) {
            checkFlow.setDescription("");
        }
        if (!checkFlow.getDescription().equals(rep.getDescription())) {
            checkFlow.setDescription(rep.getDescription());
        }
        this.realm.updateAuthenticationFlow(checkFlow);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
    }

    @Path(value="/executions/{executionId}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Get Single Execution")
    public AuthenticationExecutionRepresentation getExecution(@PathParam(value="executionId") String executionId) {
        this.auth.realm().requireManageRealm();
        Optional<AuthenticationExecutionModel> model = Optional.ofNullable(this.realm.getAuthenticationExecutionById(executionId));
        if (!model.isPresent()) {
            logger.debugv("Could not find execution by Id: {}", (Object)executionId);
            throw new NotFoundException("Illegal execution");
        }
        return ModelToRepresentation.toRepresentation((AuthenticationExecutionModel)model.get());
    }

    @Path(value="/executions")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Add new authentication execution")
    @APIResponse(responseCode="201", description="Created")
    public Response addExecution(@Parameter(description="JSON model describing authentication execution") AuthenticationExecutionRepresentation execution) {
        this.auth.realm().requireManageRealm();
        AuthenticationExecutionModel model = RepresentationToModel.toModel((KeycloakSession)this.session, (RealmModel)this.realm, (AuthenticationExecutionRepresentation)execution);
        AuthenticationFlowModel parentFlow = this.getParentFlow(model);
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to add execution to a built in flow");
        }
        int priority = execution.getPriority() != null ? execution.getPriority().intValue() : this.getNextPriority(parentFlow);
        model.setPriority(priority);
        model = this.realm.addAuthenticatorExecution(model);
        if (!execution.isAuthenticatorFlow()) {
            ProviderFactory f = this.getProviderFactory(parentFlow, execution.getAuthenticator());
            this.checkConfigForDeployedProvider(f, model);
        }
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri(), model.getId()).representation(execution).success();
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    public AuthenticationFlowModel getParentFlow(AuthenticationExecutionModel model) {
        if (model.getParentFlow() == null) {
            throw new BadRequestException("parent flow not set on new execution");
        }
        AuthenticationFlowModel parentFlow = this.realm.getAuthenticationFlowById(model.getParentFlow());
        if (parentFlow == null) {
            throw new BadRequestException("execution parent flow does not exist");
        }
        return parentFlow;
    }

    @Path(value="/executions/{executionId}/raise-priority")
    @POST
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Raise execution's priority")
    @APIResponse(responseCode="204", description="No Content")
    public void raisePriority(@Parameter(description="Execution id") @PathParam(value="executionId") String execution) {
        AuthenticationExecutionModel exe;
        this.auth.realm().requireManageRealm();
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        AuthenticationFlowModel parentFlow = this.getParentFlow(model);
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to modify execution in a built in flow");
        }
        AuthenticationExecutionModel previous = null;
        Iterator iterator = this.realm.getAuthenticationExecutionsStream(parentFlow.getId()).collect(Collectors.toList()).iterator();
        while (iterator.hasNext() && !(exe = (AuthenticationExecutionModel)iterator.next()).getId().equals(model.getId())) {
            previous = exe;
        }
        if (previous == null) {
            return;
        }
        int tmp = previous.getPriority();
        previous.setPriority(model.getPriority());
        this.realm.updateAuthenticatorExecution(previous);
        model.setPriority(tmp);
        this.realm.updateAuthenticatorExecution(model);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="/executions/{executionId}/lower-priority")
    @POST
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Lower execution's priority")
    @APIResponse(responseCode="204", description="No Content")
    public void lowerPriority(@Parameter(description="Execution id") @PathParam(value="executionId") String execution) {
        int i;
        this.auth.realm().requireManageRealm();
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        AuthenticationFlowModel parentFlow = this.getParentFlow(model);
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to modify execution in a built in flow");
        }
        List executions = this.realm.getAuthenticationExecutionsStream(parentFlow.getId()).collect(Collectors.toList());
        for (i = 0; i < executions.size() && !((AuthenticationExecutionModel)executions.get(i)).getId().equals(model.getId()); ++i) {
        }
        if (i + 1 >= executions.size()) {
            return;
        }
        AuthenticationExecutionModel next = (AuthenticationExecutionModel)executions.get(i + 1);
        int tmp = model.getPriority();
        model.setPriority(next.getPriority());
        this.realm.updateAuthenticatorExecution(model);
        next.setPriority(tmp);
        this.realm.updateAuthenticatorExecution(next);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="/executions/{executionId}")
    @DELETE
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Delete execution")
    @APIResponse(responseCode="204", description="No Content")
    public void removeExecution(@Parameter(description="Execution id") @PathParam(value="executionId") String execution) {
        this.auth.realm().requireManageRealm();
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        AuthenticationFlowModel parentFlow = this.getParentFlow(model);
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to remove execution from a built in flow");
        }
        KeycloakModelUtils.deepDeleteAuthenticationExecutor((KeycloakSession)this.session, (RealmModel)this.realm, (AuthenticationExecutionModel)model, () -> {}, () -> {
            throw new BadRequestException("It is illegal to remove execution from a built in flow");
        });
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="/executions/{executionId}/config")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Update execution with new configuration")
    @APIResponse(responseCode="201", description="Created")
    public Response newExecutionConfig(@Parameter(description="Execution id") @PathParam(value="executionId") String execution, @Parameter(description="JSON with new configuration") AuthenticatorConfigRepresentation json) {
        this.auth.realm().requireManageRealm();
        ReservedCharValidator.validate((String)json.getAlias());
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        AuthenticatorConfigModel config = RepresentationToModel.toModel((AuthenticatorConfigRepresentation)json);
        if (config.getAlias() == null) {
            throw ErrorResponse.error("Alias missing", Response.Status.BAD_REQUEST);
        }
        config = this.realm.addAuthenticatorConfig(config);
        model.setAuthenticatorConfig(config.getId());
        this.realm.updateAuthenticatorExecution(model);
        json.setId(config.getId());
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(json).success();
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(config.getId()).build(new Object[0])).build();
    }

    @Path(value="/executions/{executionId}/config/{id}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Get execution's configuration", deprecated=true)
    @Deprecated
    public AuthenticatorConfigRepresentation getAuthenticatorConfig(@Parameter(description="Execution id") @PathParam(value="executionId") String execution, @Parameter(description="Configuration id") @PathParam(value="id") String id) {
        this.auth.realm().requireViewRealm();
        AuthenticatorConfigModel config = new DeployedConfigurationsManager(this.session).getAuthenticatorConfig(this.realm, id);
        if (config == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        return ModelToRepresentation.toRepresentation((AuthenticatorConfigModel)config);
    }

    @Path(value="unregistered-required-actions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Get unregistered required actions Returns a stream of unregistered required actions.")
    public Stream<Map<String, String>> getUnregisteredRequiredActions() {
        this.auth.realm().requireViewRealm();
        Set providerIds = this.realm.getRequiredActionProvidersStream().map(RequiredActionProviderModel::getProviderId).collect(Collectors.toSet());
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(RequiredActionProvider.class).filter(factory -> !providerIds.contains(factory.getId())).map(factory -> {
            RequiredActionFactory r = (RequiredActionFactory)factory;
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("name", r.getDisplayText());
            m.put("providerId", r.getId());
            return m;
        });
    }

    @Path(value="register-required-action")
    @POST
    @Consumes(value={"application/json"})
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Register a new required actions")
    @APIResponse(responseCode="204", description="No Content")
    public void registerRequiredAction(@Parameter(description="JSON containing 'providerId', and 'name' attributes.") Map<String, String> data) {
        this.auth.realm().requireManageRealm();
        String providerId = data.get("providerId");
        if (providerId == null || this.session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, providerId) == null) {
            throw new BadRequestException("Required Action Provider with given providerId not found");
        }
        String name = data.get("name");
        RequiredActionProviderModel requiredAction = new RequiredActionProviderModel();
        requiredAction.setAlias(providerId);
        requiredAction.setName(name);
        requiredAction.setProviderId(providerId);
        requiredAction.setDefaultAction(false);
        requiredAction.setPriority(this.getNextRequiredActionPriority());
        requiredAction.setEnabled(true);
        requiredAction = this.realm.addRequiredActionProvider(requiredAction);
        data.put("id", requiredAction.getId());
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.REQUIRED_ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(data).success();
    }

    private int getNextRequiredActionPriority() {
        List actions = this.realm.getRequiredActionProvidersStream().collect(Collectors.toList());
        return actions.isEmpty() ? 0 : ((RequiredActionProviderModel)actions.get(actions.size() - 1)).getPriority() + 1;
    }

    @Path(value="required-actions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Get required actions Returns a stream of required actions.")
    public Stream<RequiredActionProviderRepresentation> getRequiredActions() {
        this.auth.realm().requireViewRequiredActions();
        return this.realm.getRequiredActionProvidersStream().map(AuthenticationManagementResource::toRepresentation);
    }

    public static RequiredActionProviderRepresentation toRepresentation(RequiredActionProviderModel model) {
        RequiredActionProviderRepresentation rep = new RequiredActionProviderRepresentation();
        rep.setAlias(model.getAlias());
        rep.setProviderId(model.getProviderId());
        rep.setName(model.getName());
        rep.setDefaultAction(model.isDefaultAction());
        rep.setPriority(model.getPriority());
        rep.setEnabled(model.isEnabled());
        rep.setConfig(model.getConfig());
        return rep;
    }

    @Path(value="required-actions/{alias}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Get required action for alias")
    public RequiredActionProviderRepresentation getRequiredAction(@Parameter(description="Alias of required action") @PathParam(value="alias") String alias) {
        this.auth.realm().requireViewRealm();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action");
        }
        return AuthenticationManagementResource.toRepresentation(model);
    }

    @Path(value="required-actions/{alias}")
    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Update required action")
    @APIResponse(responseCode="204", description="No Content")
    public void updateRequiredAction(@Parameter(description="Alias of required action") @PathParam(value="alias") String alias, @Parameter(description="JSON describing new state of required action") RequiredActionProviderRepresentation rep) {
        this.auth.realm().requireManageRealm();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action");
        }
        RequiredActionProviderModel update = new RequiredActionProviderModel();
        update.setId(model.getId());
        update.setName(rep.getName());
        update.setAlias(rep.getAlias());
        update.setProviderId(model.getProviderId());
        update.setDefaultAction(rep.isDefaultAction());
        update.setPriority(rep.getPriority());
        update.setEnabled(rep.isEnabled());
        update.setConfig(rep.getConfig());
        this.realm.updateRequiredActionProvider(update);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.REQUIRED_ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
    }

    @Path(value="required-actions/{alias}")
    @DELETE
    @Tag(name="Authentication Management")
    @Operation(summary="Delete required action")
    @APIResponse(responseCode="204", description="No Content")
    public void removeRequiredAction(@Parameter(description="Alias of required action") @PathParam(value="alias") String alias) {
        this.auth.realm().requireManageRealm();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action.");
        }
        this.realm.removeRequiredActionProvider(model);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.REQUIRED_ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="required-actions/{alias}/raise-priority")
    @POST
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Raise required action's priority")
    @APIResponse(responseCode="204", description="No Content")
    public void raiseRequiredActionPriority(@Parameter(description="Alias of required action") @PathParam(value="alias") String alias) {
        RequiredActionProviderModel action;
        this.auth.realm().requireManageRealm();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action.");
        }
        RequiredActionProviderModel previous = null;
        Iterator iterator = this.realm.getRequiredActionProvidersStream().collect(Collectors.toList()).iterator();
        while (iterator.hasNext() && !(action = (RequiredActionProviderModel)iterator.next()).getId().equals(model.getId())) {
            previous = action;
        }
        if (previous == null) {
            return;
        }
        int tmp = previous.getPriority();
        previous.setPriority(model.getPriority());
        this.realm.updateRequiredActionProvider(previous);
        model.setPriority(tmp);
        this.realm.updateRequiredActionProvider(model);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.REQUIRED_ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="/required-actions/{alias}/lower-priority")
    @POST
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Lower required action's priority")
    @APIResponse(responseCode="204", description="No Content")
    public void lowerRequiredActionPriority(@Parameter(description="Alias of required action") @PathParam(value="alias") String alias) {
        int i;
        this.auth.realm().requireManageRealm();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action.");
        }
        List actions = this.realm.getRequiredActionProvidersStream().collect(Collectors.toList());
        for (i = 0; i < actions.size() && !((RequiredActionProviderModel)actions.get(i)).getId().equals(model.getId()); ++i) {
        }
        if (i + 1 >= actions.size()) {
            return;
        }
        RequiredActionProviderModel next = (RequiredActionProviderModel)actions.get(i + 1);
        int tmp = model.getPriority();
        model.setPriority(next.getPriority());
        this.realm.updateRequiredActionProvider(model);
        next.setPriority(tmp);
        this.realm.updateRequiredActionProvider(next);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.REQUIRED_ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="required-actions/{alias}/config-description")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Get RequiredAction provider configuration description")
    public RequiredActionConfigInfoRepresentation getRequiredActionConfigDescription(@Parameter(description="Alias of required action") @PathParam(value="alias") String alias) {
        this.auth.realm().requireViewRealm();
        RequiredActionFactory factory = RequiredActionHelper.lookupConfigurableRequiredActionFactory((KeycloakSession)this.session, (String)alias);
        if (factory == null) {
            throw new NotFoundException("Could not find configurable RequiredAction provider");
        }
        RequiredActionConfigInfoRepresentation rep = new RequiredActionConfigInfoRepresentation();
        rep.setProperties(new LinkedList());
        List configProperties = Optional.ofNullable(factory.getConfigMetadata()).orElse(Collections.emptyList());
        for (ProviderConfigProperty prop : configProperties) {
            ConfigPropertyRepresentation propRep = this.getConfigPropertyRep(prop);
            rep.getProperties().add(propRep);
        }
        return rep;
    }

    @Path(value="required-actions/{alias}/config")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Get RequiredAction configuration")
    public RequiredActionConfigRepresentation getRequiredActionConfig(@Parameter(description="Alias of required action") @PathParam(value="alias") String alias) {
        this.auth.realm().requireViewRealm();
        RequiredActionFactory factory = RequiredActionHelper.lookupConfigurableRequiredActionFactory((KeycloakSession)this.session, (String)alias);
        if (factory == null) {
            throw new BadRequestException("RequiredAction is not configurable");
        }
        RequiredActionConfigModel config = this.realm.getRequiredActionConfigByAlias(alias);
        if (config == null) {
            throw new NotFoundException("Could not find RequiredAction config");
        }
        return ModelToRepresentation.toRepresentation((RequiredActionConfigModel)config);
    }

    @Path(value="required-actions/{alias}/config")
    @DELETE
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Delete RequiredAction configuration")
    @APIResponse(responseCode="204", description="No Content")
    public void removeRequiredActionConfig(@Parameter(description="Alias of required action") @PathParam(value="alias") String alias) {
        this.auth.realm().requireManageRealm();
        RequiredActionFactory factory = RequiredActionHelper.lookupConfigurableRequiredActionFactory((KeycloakSession)this.session, (String)alias);
        if (factory == null) {
            throw new BadRequestException("RequiredAction is not configurable");
        }
        RequiredActionConfigModel config = this.realm.getRequiredActionConfigByAlias(alias);
        if (config == null) {
            throw new NotFoundException("Could not find RequiredAction config");
        }
        this.realm.removeRequiredActionProviderConfig(config);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.REQUIRED_ACTION_CONFIG).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="required-actions/{alias}/config")
    @PUT
    @Consumes(value={"application/json"})
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Update RequiredAction configuration")
    @APIResponse(responseCode="204", description="No Content")
    public void updateRequiredActionConfig(@Parameter(description="Alias of required action") @PathParam(value="alias") String alias, @Parameter(description="JSON describing new state of required action configuration") RequiredActionConfigRepresentation rep) {
        this.auth.realm().requireManageRealm();
        RequiredActionFactory factory = RequiredActionHelper.lookupConfigurableRequiredActionFactory((KeycloakSession)this.session, (String)alias);
        if (factory == null) {
            throw new BadRequestException("RequiredAction is not configurable");
        }
        RequiredActionConfigModel exists = this.realm.getRequiredActionConfigByAlias(alias);
        if (exists == null) {
            throw new NotFoundException("Could not find RequiredAction config");
        }
        exists.setConfig(RepresentationToModel.removeEmptyString((Map)rep.getConfig()));
        try {
            this.realm.updateRequiredActionConfig(exists);
            this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.REQUIRED_ACTION_CONFIG).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
        }
        catch (ValidationException ve) {
            List<ErrorRepresentation> errorReps = ve.getErrors().stream().map(err -> new ErrorRepresentation(err.getAttribute(), err.getMessage(), err.getMessageParameters())).toList();
            throw ErrorResponse.errors(errorReps, Response.Status.BAD_REQUEST);
        }
    }

    @Path(value="config-description/{providerId}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Get authenticator provider's configuration description")
    public AuthenticatorConfigInfoRepresentation getAuthenticatorConfigDescription(@PathParam(value="providerId") String providerId) {
        this.auth.realm().requireViewRealm();
        ConfigurableAuthenticatorFactory factory = CredentialHelper.getConfigurableAuthenticatorFactory((KeycloakSession)this.session, (String)providerId);
        if (factory == null) {
            providerId = new String(Base32.decode((String)providerId));
            factory = CredentialHelper.getConfigurableAuthenticatorFactory((KeycloakSession)this.session, (String)providerId);
        }
        if (factory == null) {
            throw new NotFoundException("Could not find authenticator provider");
        }
        AuthenticatorConfigInfoRepresentation rep = new AuthenticatorConfigInfoRepresentation();
        rep.setProviderId(providerId);
        rep.setName(factory.getDisplayType());
        rep.setHelpText(factory.getHelpText());
        rep.setProperties(new LinkedList());
        List configProperties = Optional.ofNullable(factory.getConfigProperties()).orElse(Collections.emptyList());
        for (ProviderConfigProperty prop : configProperties) {
            ConfigPropertyRepresentation propRep = this.getConfigPropertyRep(prop);
            rep.getProperties().add(propRep);
        }
        return rep;
    }

    private ConfigPropertyRepresentation getConfigPropertyRep(ProviderConfigProperty prop) {
        return ModelToRepresentation.toRepresentation((ProviderConfigProperty)prop);
    }

    @Path(value="per-client-config-description")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Get configuration descriptions for all clients")
    public Map<String, List<ConfigPropertyRepresentation>> getPerClientConfigDescription() {
        this.auth.realm().requireViewClientAuthenticatorProviders();
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(ClientAuthenticator.class).collect(Collectors.toMap(ProviderFactory::getId, factory -> {
            ClientAuthenticatorFactory clientAuthFactory = (ClientAuthenticatorFactory)CredentialHelper.getConfigurableAuthenticatorFactory((KeycloakSession)this.session, (String)factory.getId());
            return clientAuthFactory.getConfigPropertiesPerClient().stream().map(this::getConfigPropertyRep).collect(Collectors.toList());
        }));
    }

    @Path(value="config")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Tag(name="Authentication Management")
    @Operation(summary="Create new authenticator configuration", deprecated=true)
    @APIResponse(responseCode="201", description="Created")
    @Deprecated
    public Response createAuthenticatorConfig(@Parameter(description="JSON describing new authenticator configuration") AuthenticatorConfigRepresentation rep) {
        this.auth.realm().requireManageRealm();
        ReservedCharValidator.validate((String)rep.getAlias());
        AuthenticatorConfigModel config = this.realm.addAuthenticatorConfig(RepresentationToModel.toModel((AuthenticatorConfigRepresentation)rep));
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.AUTHENTICATOR_CONFIG).resourcePath((UriInfo)this.session.getContext().getUri(), config.getId()).representation(rep).success();
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(config.getId()).build(new Object[0])).build();
    }

    @Path(value="config/{id}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Get authenticator configuration")
    public AuthenticatorConfigRepresentation getAuthenticatorConfig(@Parameter(description="Configuration id") @PathParam(value="id") String id) {
        this.auth.realm().requireViewRealm();
        AuthenticatorConfigModel config = new DeployedConfigurationsManager(this.session).getAuthenticatorConfig(this.realm, id);
        if (config == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        return ModelToRepresentation.toRepresentation((AuthenticatorConfigModel)config);
    }

    @Path(value="config/{id}")
    @DELETE
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Delete authenticator configuration")
    @APIResponse(responseCode="204", description="No Content")
    public void removeAuthenticatorConfig(@Parameter(description="Configuration id") @PathParam(value="id") String id) {
        this.auth.realm().requireManageRealm();
        AuthenticatorConfigModel config = this.realm.getAuthenticatorConfigById(id);
        if (config == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        this.realm.getAuthenticationFlowsStream().forEach(flow -> this.realm.getAuthenticationExecutionsStream(flow.getId()).filter(exe -> Objects.equals(id, exe.getAuthenticatorConfig())).forEachOrdered(exe -> {
            exe.setAuthenticatorConfig(null);
            this.realm.updateAuthenticatorExecution(exe);
        }));
        this.realm.removeAuthenticatorConfig(config);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.AUTHENTICATOR_CONFIG).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="config/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @NoCache
    @Tag(name="Authentication Management")
    @Operation(summary="Update authenticator configuration")
    @APIResponse(responseCode="204", description="No Content")
    public void updateAuthenticatorConfig(@Parameter(description="Configuration id") @PathParam(value="id") String id, @Parameter(description="JSON describing new state of authenticator configuration") AuthenticatorConfigRepresentation rep) {
        this.auth.realm().requireManageRealm();
        ReservedCharValidator.validate((String)rep.getAlias());
        if (new DeployedConfigurationsManager(this.session).getDeployedAuthenticatorConfig(id) != null) {
            throw new BadRequestException("Authenticator config is read-only");
        }
        AuthenticatorConfigModel exists = this.realm.getAuthenticatorConfigById(id);
        if (exists == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        exists.setAlias(rep.getAlias());
        exists.setConfig(RepresentationToModel.removeEmptyString((Map)rep.getConfig()));
        this.realm.updateAuthenticatorConfig(exists);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.AUTHENTICATOR_CONFIG).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
    }
}

