/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.url;

import java.net.URI;
import java.util.Optional;
import java.util.regex.Pattern;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.url.HostnameV2Provider;
import org.keycloak.urls.HostnameProvider;
import org.keycloak.urls.HostnameProviderFactory;

public class HostnameV2ProviderFactory
implements HostnameProviderFactory,
EnvironmentDependentProviderFactory {
    private String hostname;
    private URI hostnameUrl;
    private URI adminUrl;
    private Boolean backchannelDynamic;
    private static final String hostnameStringPattern = "[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?(\\.[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?)*";
    private static final Pattern hostnamePattern = Pattern.compile("^[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?(\\.[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?)*$");
    private static final Pattern hostnameUrlPattern = Pattern.compile("^(http|https)://[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?(\\.[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?)*(:\\d+)?(/[\\w-]+)*/?$");

    public void init(Config.Scope config) {
        Boolean strictMode = config.getBoolean("hostname-strict", Boolean.valueOf(false));
        String hostnameRaw = config.get("hostname");
        if (strictMode.booleanValue() && hostnameRaw == null) {
            throw new IllegalArgumentException("hostname is not configured; either configure hostname, or set hostname-strict to false");
        }
        if (hostnameRaw == null || !strictMode.booleanValue()) {
            // empty if block
        }
        if (hostnameRaw != null) {
            if (hostnamePattern.matcher(hostnameRaw).matches()) {
                this.hostname = hostnameRaw;
            } else {
                this.hostnameUrl = this.validateAndCreateUri(hostnameRaw, "Provided hostname is neither a plain hostname or a valid URL");
            }
        }
        Optional.ofNullable(config.get("hostname-admin")).ifPresent(h -> {
            this.adminUrl = this.validateAndCreateUri((String)h, "Provided hostname-admin is not a valid URL");
        });
        this.backchannelDynamic = config.getBoolean("hostname-backchannel-dynamic", Boolean.valueOf(false));
        if (this.hostname == null && this.hostnameUrl == null && this.backchannelDynamic.booleanValue()) {
            throw new IllegalArgumentException("hostname-backchannel-dynamic must be set to false when no hostname is provided");
        }
        if (this.backchannelDynamic.booleanValue() && this.hostnameUrl == null) {
            throw new IllegalArgumentException("hostname-backchannel-dynamic must be set to false if hostname is not provided as full URL");
        }
    }

    private URI validateAndCreateUri(String uri, String validationFailedMessage) {
        if (!hostnameUrlPattern.matcher(uri).matches()) {
            throw new IllegalArgumentException(validationFailedMessage);
        }
        try {
            return URI.create(uri);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(validationFailedMessage, e);
        }
    }

    public HostnameProvider create(KeycloakSession session) {
        return new HostnameV2Provider(session, this.hostname, this.hostnameUrl, this.adminUrl, this.backchannelDynamic);
    }

    public String getId() {
        return "v2";
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.HOSTNAME_V2);
    }
}

