/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.x509;

import java.util.List;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class UserIdentityToModelMapper {
    public abstract UserModel find(AuthenticationFlowContext var1, Object var2) throws Exception;

    public static UserIdentityToModelMapper getUsernameOrEmailMapper() {
        return new UsernameOrEmailMapper();
    }

    public static UserIdentityToModelMapper getUserIdentityToCustomAttributeMapper(String attributeName) {
        return new UserIdentityToCustomAttributeMapper(attributeName);
    }

    static class UserIdentityToCustomAttributeMapper
    extends UserIdentityToModelMapper {
        private String _customAttribute;

        UserIdentityToCustomAttributeMapper(String customAttribute) {
            this._customAttribute = customAttribute;
        }

        @Override
        public UserModel find(AuthenticationFlowContext context, Object userIdentity) throws Exception {
            KeycloakSession session = context.getSession();
            List users = session.users().searchForUserByUserAttribute(this._customAttribute, userIdentity.toString(), context.getRealm());
            if (users != null && users.size() > 1) {
                throw new ModelDuplicateException();
            }
            return users != null && users.size() == 1 ? (UserModel)users.get(0) : null;
        }
    }

    static class UsernameOrEmailMapper
    extends UserIdentityToModelMapper {
        UsernameOrEmailMapper() {
        }

        @Override
        public UserModel find(AuthenticationFlowContext context, Object userIdentity) throws Exception {
            return KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)context.getSession(), (RealmModel)context.getRealm(), (String)userIdentity.toString().trim());
        }
    }
}

