/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.AuthorizationProviderFactory;
import org.keycloak.authorization.policy.evaluation.DefaultPolicyEvaluator;
import org.keycloak.authorization.policy.evaluation.PolicyEvaluator;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;

public class DefaultAuthorizationProviderFactory
implements AuthorizationProviderFactory {
    private Map<String, PolicyProviderFactory> policyProviderFactories;
    private PolicyEvaluator policyEvaluator = new DefaultPolicyEvaluator();

    public AuthorizationProvider create(KeycloakSession session) {
        return this.create(session, session.getContext().getRealm());
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.policyProviderFactories = this.configurePolicyProviderFactories(factory);
    }

    public void close() {
    }

    public String getId() {
        return "authorization";
    }

    public AuthorizationProvider create(KeycloakSession session, RealmModel realm) {
        return new AuthorizationProvider(session, realm, this.policyProviderFactories, this.policyEvaluator);
    }

    private Map<String, PolicyProviderFactory> configurePolicyProviderFactories(KeycloakSessionFactory keycloakSessionFactory) {
        List providerFactories = keycloakSessionFactory.getProviderFactories(PolicyProvider.class);
        if (providerFactories.isEmpty()) {
            throw new RuntimeException("Could not find any policy provider.");
        }
        HashMap<String, PolicyProviderFactory> providers = new HashMap<String, PolicyProviderFactory>();
        providerFactories.forEach(providerFactory -> providers.put(providerFactory.getId(), (PolicyProviderFactory)providerFactory));
        return providers;
    }
}

