/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.admin.representation.PolicyEvaluationResponseBuilder;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.common.KeycloakEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DecisionPermissionCollector;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PolicyEvaluationRequest;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.sessions.AuthenticationSessionModel;

public class PolicyEvaluationService {
    private static final Logger logger = Logger.getLogger(PolicyEvaluationService.class);
    private final AuthorizationProvider authorization;
    private final AdminPermissionEvaluator auth;
    private final ResourceServer resourceServer;

    PolicyEvaluationService(ResourceServer resourceServer, AuthorizationProvider authorization, AdminPermissionEvaluator auth) {
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response evaluate(PolicyEvaluationRequest evaluationRequest) {
        this.auth.realm().requireViewAuthorization();
        try (CloseableKeycloakIdentity identity = this.createIdentity(evaluationRequest);){
            AuthorizationRequest request = new AuthorizationRequest();
            HashMap claims = new HashMap();
            Map givenAttributes = (Map)evaluationRequest.getContext().get("attributes");
            if (givenAttributes != null) {
                givenAttributes.forEach((key, entryValue) -> {
                    if (entryValue != null) {
                        ArrayList<String> values = new ArrayList<String>();
                        for (String value : entryValue.split(",")) {
                            values.add(value);
                        }
                        claims.put(key, values);
                    }
                });
            }
            request.setClaims(claims);
            Response response = Response.ok((Object)PolicyEvaluationResponseBuilder.build(this.evaluate(evaluationRequest, this.createEvaluationContext(evaluationRequest, identity), request), this.resourceServer, this.authorization, identity)).build();
            return response;
        }
    }

    private EvaluationDecisionCollector evaluate(PolicyEvaluationRequest evaluationRequest, EvaluationContext evaluationContext, AuthorizationRequest request) {
        return (EvaluationDecisionCollector)this.authorization.evaluators().from(this.createPermissions(evaluationRequest, evaluationContext, this.authorization, request), evaluationContext).evaluate((Decision)new EvaluationDecisionCollector(this.authorization, this.resourceServer, request));
    }

    private EvaluationContext createEvaluationContext(final PolicyEvaluationRequest representation, KeycloakIdentity identity) {
        return new KeycloakEvaluationContext(identity, this.authorization.getKeycloakSession()){

            @Override
            public Attributes getAttributes() {
                HashMap attributes = new HashMap(super.getAttributes().toMap());
                Map givenAttributes = (Map)representation.getContext().get("attributes");
                if (givenAttributes != null) {
                    givenAttributes.forEach((key, entryValue) -> {
                        if (entryValue != null) {
                            ArrayList<String> values = new ArrayList<String>();
                            for (String value : entryValue.split(",")) {
                                values.add(value);
                            }
                            attributes.put(key, values);
                        }
                    });
                }
                return Attributes.from(attributes);
            }
        };
    }

    private List<ResourcePermission> createPermissions(PolicyEvaluationRequest representation, EvaluationContext evaluationContext, AuthorizationProvider authorization, AuthorizationRequest request) {
        return representation.getResources().stream().flatMap(resource -> {
            HashSet givenScopes;
            StoreFactory storeFactory = authorization.getStoreFactory();
            if (resource == null) {
                resource = new ResourceRepresentation();
            }
            if ((givenScopes = resource.getScopes()) == null) {
                givenScopes = new HashSet();
            }
            ScopeStore scopeStore = storeFactory.getScopeStore();
            Set<Scope> scopes = givenScopes.stream().map(scopeRepresentation -> scopeStore.findByName(scopeRepresentation.getName(), this.resourceServer.getId())).collect(Collectors.toSet());
            if (resource.getId() != null) {
                Resource resourceModel = storeFactory.getResourceStore().findById(resource.getId(), this.resourceServer.getId());
                return new ArrayList<ResourcePermission>(Arrays.asList(Permissions.createResourcePermissions(resourceModel, scopes, authorization, request))).stream();
            }
            if (resource.getType() != null) {
                return storeFactory.getResourceStore().findByType(resource.getType(), this.resourceServer.getId()).stream().map(resource1 -> Permissions.createResourcePermissions(resource1, scopes, authorization, request));
            }
            if (scopes.isEmpty()) {
                return Permissions.all(this.resourceServer, evaluationContext.getIdentity(), authorization, request).stream();
            }
            List resources = storeFactory.getResourceStore().findByScope(scopes.stream().map(Scope::getId).collect(Collectors.toList()), this.resourceServer.getId());
            if (resources.isEmpty()) {
                return scopes.stream().map(scope -> new ResourcePermission(null, new ArrayList<Scope>(Arrays.asList(scope)), this.resourceServer));
            }
            return resources.stream().map(resource12 -> Permissions.createResourcePermissions(resource12, scopes, authorization, request));
        }).collect(Collectors.toList());
    }

    private CloseableKeycloakIdentity createIdentity(PolicyEvaluationRequest representation) {
        UserModel userModel;
        KeycloakSession keycloakSession = this.authorization.getKeycloakSession();
        RealmModel realm = keycloakSession.getContext().getRealm();
        AccessToken accessToken = null;
        String subject = representation.getUserId();
        UserSessionModel userSession = null;
        if (subject != null && (userModel = keycloakSession.users().getUserById(subject, realm)) != null) {
            String clientId = representation.getClientId();
            if (clientId == null) {
                clientId = this.resourceServer.getId();
            }
            if (clientId != null) {
                ClientModel clientModel = realm.getClientById(clientId);
                AuthenticationSessionModel authSession = keycloakSession.authenticationSessions().createRootAuthenticationSession(realm).createAuthenticationSession(clientModel);
                authSession.setProtocol("openid-connect");
                authSession.setAuthenticatedUser(userModel);
                userSession = keycloakSession.sessions().createUserSession(authSession.getParentSession().getId(), realm, userModel, userModel.getUsername(), "127.0.0.1", "passwd", false, null, null);
                AuthenticationManager.setClientScopesInSession(authSession);
                ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(keycloakSession, userSession, authSession);
                accessToken = new TokenManager().createClientAccessToken(keycloakSession, realm, clientModel, userModel, userSession, clientSessionCtx);
            }
        }
        if (accessToken == null) {
            accessToken = new AccessToken();
            accessToken.subject(representation.getUserId());
            accessToken.issuedFor(representation.getClientId());
            accessToken.audience(new String[]{representation.getClientId()});
            accessToken.issuer(Urls.realmIssuer(keycloakSession.getContext().getUri().getBaseUri(), realm.getName()));
            accessToken.setRealmAccess(new AccessToken.Access());
        }
        AccessToken.Access realmAccess = accessToken.getRealmAccess();
        if (representation.getRoleIds() != null) {
            representation.getRoleIds().forEach(roleName -> realmAccess.addRole(roleName));
        }
        return new CloseableKeycloakIdentity(accessToken, keycloakSession, userSession);
    }

    public class EvaluationDecisionCollector
    extends DecisionPermissionCollector {
        public EvaluationDecisionCollector(AuthorizationProvider authorizationProvider, ResourceServer resourceServer, AuthorizationRequest request) {
            super(authorizationProvider, resourceServer, request);
        }

        protected boolean isGranted(Result.PolicyResult policyResult) {
            if (super.isGranted(policyResult)) {
                policyResult.setEffect(Decision.Effect.PERMIT);
                return true;
            }
            return false;
        }

        protected void grantPermission(AuthorizationProvider authorizationProvider, List<Permission> permissions, ResourcePermission permission, Collection<Scope> grantedScopes, ResourceServer resourceServer, AuthorizationRequest request, Result result) {
            result.setStatus(Decision.Effect.PERMIT);
            result.getPermission().getScopes().retainAll(grantedScopes);
            super.grantPermission(authorizationProvider, permissions, permission, grantedScopes, resourceServer, request, result);
        }

        public Collection<Result> getResults() {
            return this.results.values();
        }
    }

    private static class CloseableKeycloakIdentity
    extends KeycloakIdentity {
        private UserSessionModel userSession;

        public CloseableKeycloakIdentity(AccessToken accessToken, KeycloakSession keycloakSession, UserSessionModel userSession) {
            super(accessToken, keycloakSession);
            this.userSession = userSession;
        }

        public void close() {
            if (this.userSession != null) {
                this.keycloakSession.sessions().removeUserSession(this.realm, this.userSession);
            }
        }
    }
}

