/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.loader;

import java.security.PublicKey;
import java.util.Collections;
import java.util.Map;
import org.keycloak.common.util.PemUtils;
import org.keycloak.keys.PublicKeyLoader;

public class HardcodedPublicKeyLoader
implements PublicKeyLoader {
    private final String kid;
    private final String pem;

    public HardcodedPublicKeyLoader(String kid, String pem) {
        this.kid = kid;
        this.pem = pem;
    }

    public Map<String, PublicKey> loadKeys() throws Exception {
        return Collections.unmodifiableMap(Collections.singletonMap(this.kid, this.getSavedPublicKey()));
    }

    protected PublicKey getSavedPublicKey() {
        if (this.pem != null && !this.pem.trim().equals("")) {
            return PemUtils.decodePublicKey((String)this.pem);
        }
        return null;
    }
}

