/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import java.util.List;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.partialimport.AbstractPartialImport;
import org.keycloak.partialimport.ResourceType;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;

public class IdentityProvidersPartialImport
extends AbstractPartialImport<IdentityProviderRepresentation> {
    @Override
    public List<IdentityProviderRepresentation> getRepList(PartialImportRepresentation partialImportRep) {
        return partialImportRep.getIdentityProviders();
    }

    @Override
    public String getName(IdentityProviderRepresentation idpRep) {
        return idpRep.getAlias();
    }

    @Override
    public String getModelId(RealmModel realm, KeycloakSession session, IdentityProviderRepresentation idpRep) {
        return realm.getIdentityProviderByAlias(this.getName(idpRep)).getInternalId();
    }

    @Override
    public boolean exists(RealmModel realm, KeycloakSession session, IdentityProviderRepresentation idpRep) {
        return realm.getIdentityProviderByAlias(this.getName(idpRep)) != null;
    }

    @Override
    public String existsMessage(RealmModel realm, IdentityProviderRepresentation idpRep) {
        return "Identity Provider '" + this.getName(idpRep) + "' already exists.";
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.IDP;
    }

    @Override
    public void remove(RealmModel realm, KeycloakSession session, IdentityProviderRepresentation idpRep) {
        realm.removeIdentityProviderByAlias(this.getName(idpRep));
    }

    @Override
    public void create(RealmModel realm, KeycloakSession session, IdentityProviderRepresentation idpRep) {
        idpRep.setInternalId(KeycloakModelUtils.generateId());
        IdentityProviderModel identityProvider = RepresentationToModel.toModel((RealmModel)realm, (IdentityProviderRepresentation)idpRep);
        realm.addIdentityProvider(identityProvider);
    }
}

