/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ClientScopeEvaluateScopeMappingsResource {
    private final RoleContainerModel roleContainer;
    private final AdminPermissionEvaluator auth;
    private final ClientModel client;
    private final String scopeParam;
    private final KeycloakSession session;

    public ClientScopeEvaluateScopeMappingsResource(RoleContainerModel roleContainer, AdminPermissionEvaluator auth, ClientModel client, String scopeParam, KeycloakSession session) {
        this.roleContainer = roleContainer;
        this.auth = auth;
        this.client = client;
        this.scopeParam = scopeParam;
        this.session = session;
    }

    @Path(value="/granted")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getGrantedScopeMappings() {
        return this.getGrantedRoles().stream().map(role -> ModelToRepresentation.toRepresentation((RoleModel)role)).collect(Collectors.toList());
    }

    @Path(value="/not-granted")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getNotGrantedScopeMappings() {
        List<RoleModel> grantedRoles = this.getGrantedRoles();
        return this.roleContainer.getRoles().stream().filter(role -> !grantedRoles.contains(role)).map(role -> ModelToRepresentation.toRepresentation((RoleModel)role)).collect(Collectors.toList());
    }

    private List<RoleModel> getGrantedRoles() {
        if (this.client.isFullScopeAllowed()) {
            return new LinkedList<RoleModel>(this.roleContainer.getRoles());
        }
        Set<ClientScopeModel> clientScopes = TokenManager.getRequestedClientScopes(this.scopeParam, this.client);
        LinkedList<RoleModel> result = new LinkedList<RoleModel>();
        block0: for (RoleModel role : this.roleContainer.getRoles()) {
            if (!this.auth.roles().canView(role)) continue;
            for (ScopeContainerModel scopeContainerModel : clientScopes) {
                if (!scopeContainerModel.hasScope(role)) continue;
                result.add(role);
                continue block0;
            }
        }
        return result;
    }
}

