/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.jaxb;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

public class LocalTimeXmlAdapter
extends XmlAdapter<String, LocalTime> {
    private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();

    public LocalTime unmarshal(String localTimeString) throws Exception {
        if (localTimeString == null) {
            return null;
        }
        try {
            return LocalTime.from(this.formatter.parse(localTimeString));
        }
        catch (DateTimeException e) {
            throw new IllegalStateException("Failed to convert string (" + localTimeString + ") to type (" + LocalTime.class.getName() + ").");
        }
    }

    public String marshal(LocalTime localTimeObject) throws Exception {
        if (localTimeObject == null) {
            return null;
        }
        return this.formatter.format(localTimeObject);
    }
}

