/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.admin.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.admin.CaseAdminServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class CaseAdminServicesClientImpl
extends AbstractKieServicesClientImpl
implements CaseAdminServicesClient {
    public CaseAdminServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public CaseAdminServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public List<CaseInstance> getCaseInstances(Integer page, Integer pageSize) {
        return this.getCaseInstances(null, page, pageSize, "", true);
    }

    @Override
    public List<CaseInstance> getCaseInstances(List<String> status, Integer page, Integer pageSize) {
        return this.getCaseInstances(status, page, pageSize, "", true);
    }

    @Override
    public List<CaseInstance> getCaseInstances(Integer page, Integer pageSize, String sort, boolean sortOrder) {
        return this.getCaseInstances(null, page, pageSize, sort, sortOrder);
    }

    @Override
    public List<CaseInstance> getCaseInstances(List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        CaseInstanceList list = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("", page, pageSize);
            queryString = this.getAdditionalParams(queryString, "status", status);
            queryString = this.getSortingQueryString(queryString, sort, sortOrder);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/cases/instances", valuesMap) + queryString, CaseInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getCaseInstances", new Object[]{this.safeList(status), page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (CaseInstanceList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }
}

