/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.credentials;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.kie.server.client.CredentialsProvider;

public class SubjectCredentialsProvider
implements CredentialsProvider {
    @Override
    public String getHeaderName() {
        return "Authorization";
    }

    @Override
    public String getAuthorization() {
        Subject subject = this.getSubjectFromContainer();
        if (subject != null && subject.getPrincipals() != null) {
            Set<Principal> principals = subject.getPrincipals();
            for (Principal principal : principals) {
                if (!this.match(principal)) continue;
                return principal.getName();
            }
        }
        return null;
    }

    protected Subject getSubjectFromContainer() {
        try {
            return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean match(Principal principal) {
        return principal.getClass().getName().endsWith("BasicAuthorizationPrincipal");
    }
}

