/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.Collections;
import java.util.List;
import org.kie.server.api.model.definition.ProcessInstanceQueryFilterSpec;
import org.kie.server.api.model.definition.TaskQueryFilterSpec;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.model.instance.TaskInstanceList;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.SearchServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class SearchServicesClientImpl
extends AbstractKieServicesClientImpl
implements SearchServicesClient {
    public SearchServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public SearchServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public List<ProcessInstance> findProcessInstancesWithFilters(ProcessInstanceQueryFilterSpec filterSpec, Integer page, Integer pageSize) {
        ProcessInstanceList result = null;
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("This operation does not yet provide support for non-REST commands.");
        }
        String queryString = this.getPagingQueryString("?", page, pageSize);
        result = this.makeHttpPostRequestAndCreateCustomResponse(this.loadBalancer.getUrl() + "/" + "processes/instances/filtered-data" + queryString, filterSpec, ProcessInstanceList.class);
        if (result != null) {
            return result.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskInstance> findHumanTasksWithFilters(TaskQueryFilterSpec filterSpec, Integer page, Integer pageSize) {
        TaskInstanceList result = null;
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("This operation does not yet provide support for non-REST commands.");
        }
        String queryString = this.getPagingQueryString("?", page, pageSize);
        result = this.makeHttpPostRequestAndCreateCustomResponse(this.loadBalancer.getUrl() + "/" + "tasks/instances/filtered-data" + queryString, filterSpec, TaskInstanceList.class);
        if (result != null) {
            return result.getItems();
        }
        return Collections.emptyList();
    }
}

