/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.impl.marshal.MarshallerHelper;

@Api(value="KIE Server and KIE containers")
@Path(value="server/config")
public class KieServerResource {
    private KieContainerCommandService delegate;
    private MarshallerHelper marshallerHelper = new MarshallerHelper(null);

    public KieServerResource() {
    }

    public KieServerResource(KieContainerCommandService delegate) {
        this.delegate = delegate;
    }

    @ApiOperation(value="Executes one or more KIE Server commands for server-related or container-related operations", response=ServiceResponsesList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"response\": [\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"Container command-script-container successfully deployed with module com.redhat:Project1:1.0.\",\n      \"result\": {\n        \"kie-container\": {\n          \"container-id\": \"command-script-container\",\n          \"release-id\": {\n            \"group-id\": \"com.redhat\",\n            \"artifact-id\": \"Project1\",\n            \"version\": \"1.0\"\n          },\n          \"resolved-release-id\": {\n            \"group-id\": \"com.redhat\",\n            \"artifact-id\": \"Project1\",\n            \"version\": \"1.0\"\n          },\n          \"status\": \"DISPOSING\",\n          \"scanner\": {\n            \"status\": \"DISPOSED\",\n            \"poll-interval\": null\n          },\n          \"config-items\": [],\n          \"messages\": [\n            {\n              \"severity\": \"INFO\",\n              \"timestamp\": {\n                \"java.util.Date\": 1538768011150\n              },\n              \"content\": [\n                \"Container command-script-container successfully created with module com.redhat:Project1:1.0.\"\n              ]\n            }\n          ],\n          \"container-alias\": null\n        }\n      }\n    },\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"Container command-script-container successfully called.\",\n      \"result\": \"{\\n  \\\"results\\\" : [ ],\\n  \\\"facts\\\" : [ ]\\n}\"\n    },\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"Container command-script-container successfully disposed.\",\n      \"result\": null\n    }\n  ]\n}")}))})
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response executeCommands(@Context HttpHeaders headers, @ApiParam(value="command script payload", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"commands\": [\n    {\n      \"create-container\": {\n        \"container\": {\n          \"status\": \"STARTED\",\n          \"container-id\": \"command-script-container\",\n          \"release-id\": {\n            \"version\": \"1.0\",\n            \"group-id\": \"com.redhat\",\n            \"artifact-id\": \"Project1\"\n          }\n        }\n      }\n    },\n    {\n      \"call-container\": {\n        \"payload\": \"{\\n  \\\"commands\\\" : [ {\\n    \\\"fire-all-rules\\\" : {\\n      \\\"max\\\" : -1,\\n      \\\"out-identifier\\\" : null\\n    }\\n  } ]\\n}\",\n        \"container-id\": \"command-script-container\"\n      }\n    },\n    {\n      \"dispose-container\": {\n        \"container-id\": \"command-script-container\"\n      }\n    }\n  ]\n}")})) String commandScriptPayload) {
        String contentType = RestUtils.getContentType(headers);
        CommandScript command = (CommandScript)this.marshallerHelper.unmarshal(commandScriptPayload, contentType, CommandScript.class);
        ServiceResponsesList result = this.delegate.executeScript(command, MarshallerHelper.getFormat((String)contentType), null);
        return RestUtils.createCorrectVariant((Object)result, headers, new Header[0]);
    }
}

