/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.hibernate.converter.HibernatePersistentCollectionConverter;
import com.thoughtworks.xstream.hibernate.converter.HibernatePersistentMapConverter;
import com.thoughtworks.xstream.hibernate.converter.HibernatePersistentSortedMapConverter;
import com.thoughtworks.xstream.hibernate.converter.HibernatePersistentSortedSetConverter;
import com.thoughtworks.xstream.hibernate.converter.HibernateProxyConverter;
import com.thoughtworks.xstream.hibernate.mapper.HibernateMapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import org.kie.server.api.marshalling.xstream.XStreamMarshaller;
import org.kie.server.api.marshalling.xstream.XStreamMarshallerExtension;

public class HibernateXStreamMarshallerExtension
implements XStreamMarshallerExtension {
    public void extend(XStreamMarshaller marshaller) {
        XStream xstream = marshaller.getXstream();
        xstream.registerConverter((Converter)new HibernateProxyConverter());
        xstream.registerConverter((Converter)new HibernatePersistentCollectionConverter(xstream.getMapper()));
        xstream.registerConverter((Converter)new HibernatePersistentMapConverter(xstream.getMapper()));
        xstream.registerConverter((Converter)new HibernatePersistentSortedMapConverter(xstream.getMapper()));
        xstream.registerConverter((Converter)new HibernatePersistentSortedSetConverter(xstream.getMapper()));
    }

    public MapperWrapper chainMapperWrapper(MapperWrapper next) {
        return new HibernateMapper(next);
    }
}

