/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.bar;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.CategoryChartBuilder;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.Histogram;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.Styler;

public class BarChart10
implements ExampleChart<CategoryChart> {
    public static void main(String[] args) {
        BarChart10 exampleChart = new BarChart10();
        CategoryChart chart = (CategoryChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    @Override
    public CategoryChart getChart() {
        CategoryChart chart = ((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)new CategoryChartBuilder().width(800)).height(600)).title(this.getClass().getSimpleName())).xAxisTitle("Mean").yAxisTitle("Count").build();
        ((CategoryStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideNW);
        ((CategoryStyler)chart.getStyler()).setAvailableSpaceFill(0.96);
        ((CategoryStyler)chart.getStyler()).setPlotGridVerticalLinesVisible(false);
        ((CategoryStyler)chart.getStyler()).setOverlapped(true);
        Histogram histogram1 = new Histogram(this.getGaussianData(10000), 20, -20.0, 20.0);
        Histogram histogram2 = new Histogram(this.getGaussianData(5000), 20, -20.0, 20.0);
        CategorySeries series1 = chart.addSeries("histogram 2", histogram2.getxAxisData(), histogram2.getyAxisData());
        CategorySeries series2 = chart.addSeries("histogram 1", histogram1.getxAxisData(), histogram1.getyAxisData());
        series2.setChartCategorySeriesRenderStyle(CategorySeries.CategorySeriesRenderStyle.SteppedBar);
        series1.setChartCategorySeriesRenderStyle(CategorySeries.CategorySeriesRenderStyle.SteppedBar);
        series1.setLineColor(new Color(0, 0, 0, 0));
        series2.setFillColor(new Color(0, 0, 0, 0));
        BasicStroke baseLineStyle = new BasicStroke();
        BasicStroke newLineStyle = new BasicStroke(2.0f, baseLineStyle.getEndCap(), baseLineStyle.getLineJoin(), baseLineStyle.getMiterLimit(), new float[]{5.0f, 5.0f}, baseLineStyle.getDashPhase());
        series2.setLineStyle(newLineStyle);
        return chart;
    }

    private List<Double> getGaussianData(int count) {
        ArrayList<Double> data = new ArrayList<Double>(count);
        Random r = new Random();
        for (int i = 0; i < count; ++i) {
            data.add(r.nextGaussian() * 10.0);
        }
        return data;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Stepped Bars with Line Styling";
    }
}

