/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class DateChart01
implements ExampleChart<XYChart> {
    public static void main(String[] args) {
        DateChart01 exampleChart = new DateChart01();
        XYChart chart = (XYChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    @Override
    public XYChart getChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title(this.getClass().getSimpleName())).build();
        ((XYStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.OutsideS);
        ((XYStyler)chart.getStyler()).setLegendLayout(Styler.LegendLayout.Horizontal);
        ((XYStyler)chart.getStyler()).setZoomEnabled(true);
        Random random = new Random();
        ArrayList<Date> xData1 = new ArrayList<Date>();
        ArrayList<Double> yData1 = new ArrayList<Double>();
        ArrayList<Date> xData2 = new ArrayList<Date>();
        ArrayList<Double> yData2 = new ArrayList<Double>();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.S");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = null;
        for (int i = 1; i <= 14; ++i) {
            try {
                date = sdf.parse("23:45:31." + (100 * i + random.nextInt(20)));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            xData1.add(date);
            xData2.add(date);
            yData1.add(Math.random() * (double)i);
            yData2.add(Math.random() * (double)i * 100.0);
        }
        XYSeries series = chart.addSeries("series 1", xData1, yData1);
        series.setMarker(SeriesMarkers.NONE);
        chart.addSeries("series 2", xData2, yData2).setMarker(SeriesMarkers.NONE).setYAxisGroup(1);
        return chart;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Millisecond Scale with Two Separate Y Axis Groups";
    }
}

