/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;

public class DateChart06
implements ExampleChart<XYChart> {
    public static void main(String[] args) {
        DateChart06 exampleChart = new DateChart06();
        XYChart chart = (XYChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    @Override
    public XYChart getChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title("Month Scale")).build();
        ((XYStyler)chart.getStyler()).setLegendVisible(false);
        ArrayList<Date> xData = new ArrayList<Date>();
        ArrayList<Double> yData = new ArrayList<Double>();
        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = null;
        for (int i = 1; i <= 14; ++i) {
            try {
                date = sdf.parse("2013-" + (2 * i + random.nextInt(1)));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            xData.add(date);
            yData.add(Math.random() * (double)i);
        }
        chart.addSeries("blah", xData, yData);
        ((XYStyler)chart.getStyler()).setyAxisTickLabelsFormattingFunction(x -> NumberWordConverter.convert(x.intValue()));
        return chart;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Month Scale with custom Y-Axis tick labels";
    }

    static class NumberWordConverter {
        public static final String[] units = new String[]{"", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
        public static final String[] tens = new String[]{"", "", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};

        NumberWordConverter() {
        }

        public static String convert(int n) {
            if (n == 0) {
                return "zero";
            }
            if (n < 0) {
                return "minus " + NumberWordConverter.convert(-n);
            }
            if (n < 20) {
                return units[n];
            }
            if (n < 100) {
                return tens[n / 10] + (n % 10 != 0 ? " " : "") + units[n % 10];
            }
            if (n < 1000) {
                return units[n / 100] + " hundred" + (n % 100 != 0 ? " " : "") + NumberWordConverter.convert(n % 100);
            }
            if (n < 1000000) {
                return NumberWordConverter.convert(n / 1000) + " thousand" + (n % 1000 != 0 ? " " : "") + NumberWordConverter.convert(n % 1000);
            }
            if (n < 1000000000) {
                return NumberWordConverter.convert(n / 1000000) + " million" + (n % 1000000 != 0 ? " " : "") + NumberWordConverter.convert(n % 1000000);
            }
            return NumberWordConverter.convert(n / 1000000000) + " billion" + (n % 1000000000 != 0 ? " " : "") + NumberWordConverter.convert(n % 1000000000);
        }
    }
}

