/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.date;

import java.time.LocalDateTime;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;

public class DateChart09
implements ExampleChart<XYChart> {
    public static void main(String[] args) {
        DateChart09 exampleChart = new DateChart09();
        XYChart chart = (XYChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    @Override
    public XYChart getChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title(this.getClass().getSimpleName())).build();
        ((XYStyler)chart.getStyler()).setLegendVisible(false);
        ((XYStyler)chart.getStyler()).setXAxisLabelRotation(90);
        List xData = IntStream.range(0, 365).boxed().collect(Collectors.toList());
        Random random = new Random();
        List yData = IntStream.range(0, xData.size()).mapToDouble(x -> random.nextDouble()).boxed().collect(Collectors.toList());
        chart.addSeries("blah", xData, yData);
        LocalDateTime startTime = LocalDateTime.of(2001, Month.JANUARY, 1, 0, 0, 0);
        DateTimeFormatter xTickFormatter = DateTimeFormatter.ofPattern("LLL");
        ((XYStyler)chart.getStyler()).setxAxisTickLabelsFormattingFunction(x -> startTime.plusDays(x.longValue()).format(xTickFormatter));
        ((XYStyler)chart.getStyler()).setCursorEnabled(true);
        DateTimeFormatter cursorXFormatter = DateTimeFormatter.ofPattern("LLL dd");
        ((XYStyler)chart.getStyler()).setCustomCursorXDataFormattingFunction(x -> startTime.plusDays(x.longValue()).format(cursorXFormatter));
        return chart;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Custom Date Formatter Without Years";
    }
}

