/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.line;

import java.util.ArrayList;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.colors.XChartSeriesColors;
import org.knowm.xchart.style.lines.SeriesLines;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class LineChart02
implements ExampleChart<XYChart> {
    public static void main(String[] args) {
        LineChart02 exampleChart = new LineChart02();
        XYChart chart = (XYChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    @Override
    public XYChart getChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title(this.getClass().getSimpleName())).build();
        ((XYStyler)chart.getStyler()).setChartTitleVisible(false);
        ((XYStyler)chart.getStyler()).setLegendVisible(false);
        int size = 30;
        ArrayList<Integer> xData = new ArrayList<Integer>();
        ArrayList<Double> yData = new ArrayList<Double>();
        for (int i = 0; i <= size; ++i) {
            double radians = Math.PI / (double)(size / 2) * (double)i;
            xData.add(i - size / 2);
            yData.add(-1.0E-6 * Math.sin(radians));
        }
        ArrayList<Integer> xData2 = new ArrayList<Integer>();
        ArrayList<Double> yData2 = new ArrayList<Double>();
        for (int i = 0; i <= size; ++i) {
            double radians = Math.PI / (double)(size / 2) * (double)i;
            xData2.add(i - size / 2);
            yData2.add(-1.0E-6 * Math.cos(radians));
        }
        XYSeries series = chart.addSeries("y=sin(x)", xData, yData);
        series.setLineColor(XChartSeriesColors.PURPLE);
        series.setLineStyle(SeriesLines.DASH_DASH);
        series.setMarkerColor(XChartSeriesColors.GREEN);
        series.setMarker(SeriesMarkers.SQUARE);
        series = chart.addSeries("y=cos(x)", xData2, yData2);
        series.setLineColor(XChartSeriesColors.PINK);
        series.setLineWidth(5.0f);
        series.setMarker(SeriesMarkers.NONE);
        return chart;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Customized Series Style";
    }
}

