/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.realtime;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.demo.charts.RealtimeExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;

public class RealtimeChart01
implements ExampleChart<XYChart>,
RealtimeExampleChart {
    private XYChart xyChart;
    private List<Double> yData;
    public static final String SERIES_NAME = "series1";

    public static void main(String[] args) {
        RealtimeChart01 realtimeChart01 = new RealtimeChart01();
        realtimeChart01.go();
    }

    private void go() {
        final SwingWrapper swingWrapper = new SwingWrapper((Chart)this.getChart());
        swingWrapper.displayChart();
        TimerTask chartUpdaterTask = new TimerTask(){

            @Override
            public void run() {
                RealtimeChart01.this.updateData();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        swingWrapper.repaintChart();
                    }
                });
            }
        };
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(chartUpdaterTask, 0L, 500L);
    }

    @Override
    public XYChart getChart() {
        this.yData = this.getRandomData(5);
        this.xyChart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(500)).height(400)).theme(Styler.ChartTheme.Matlab)).title("Real-time XY Chart")).build();
        this.xyChart.addSeries(SERIES_NAME, null, this.yData);
        return this.xyChart;
    }

    @Override
    public void updateData() {
        List<Double> newData = this.getRandomData(1);
        this.yData.addAll(newData);
        while (this.yData.size() > 20) {
            this.yData.remove(0);
        }
        this.xyChart.updateXYSeries(SERIES_NAME, null, this.yData, null);
    }

    private List<Double> getRandomData(int numPoints) {
        CopyOnWriteArrayList<Double> data = new CopyOnWriteArrayList<Double>();
        for (int i = 0; i < numPoints; ++i) {
            data.add(Math.random() * 100.0);
        }
        return data;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Real-time XY Chart";
    }
}

