/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.realtime;

import java.awt.Component;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.knowm.xchart.BubbleChart;
import org.knowm.xchart.BubbleChartBuilder;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.demo.charts.RealtimeExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;

public class RealtimeChart04
implements ExampleChart<BubbleChart>,
RealtimeExampleChart {
    private BubbleChart bubbleChart;
    private List<Double> yData;
    private List<Double> bubbleData;
    public static final String SERIES_NAME = "series1";

    public static void main(String[] args) {
        final RealtimeChart04 realtimeChart04 = new RealtimeChart04();
        final XChartPanel<BubbleChart> chartPanel = realtimeChart04.buildPanel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("XChart");
                frame.setDefaultCloseOperation(3);
                frame.add((Component)chartPanel);
                frame.pack();
                frame.setVisible(true);
            }
        });
        TimerTask chartUpdaterTask = new TimerTask(){

            @Override
            public void run() {
                realtimeChart04.updateData();
                chartPanel.revalidate();
                chartPanel.repaint();
            }
        };
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(chartUpdaterTask, 0L, 500L);
    }

    public XChartPanel<BubbleChart> buildPanel() {
        return new XChartPanel((Chart)this.getChart());
    }

    @Override
    public BubbleChart getChart() {
        this.yData = this.getRandomData(5);
        this.bubbleData = this.getRandomData(5);
        this.bubbleChart = ((BubbleChartBuilder)((BubbleChartBuilder)((BubbleChartBuilder)((BubbleChartBuilder)new BubbleChartBuilder().width(500)).height(400)).theme(Styler.ChartTheme.GGPlot2)).xAxisTitle("X").yAxisTitle("Y").title("Real-time Bubble Chart")).build();
        this.bubbleChart.addSeries(SERIES_NAME, null, this.yData, this.bubbleData);
        return this.bubbleChart;
    }

    private List<Double> getRandomData(int numPoints) {
        CopyOnWriteArrayList<Double> data = new CopyOnWriteArrayList<Double>();
        for (int i = 0; i < numPoints; ++i) {
            data.add(Math.random() * 100.0);
        }
        return data;
    }

    @Override
    public void updateData() {
        List<Double> newData = this.getRandomData(1);
        this.yData.addAll(newData);
        while (this.yData.size() > 20) {
            this.yData.remove(0);
        }
        newData = this.getRandomData(1);
        this.bubbleData.addAll(newData);
        while (this.bubbleData.size() > 20) {
            this.bubbleData.remove(0);
        }
        this.bubbleChart.updateBubbleSeries(SERIES_NAME, null, this.yData, this.bubbleData);
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Real-time Bubble Chart";
    }
}

