/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.realtime;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.knowm.xchart.OHLCChart;
import org.knowm.xchart.OHLCChartBuilder;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.demo.charts.RealtimeExampleChart;
import org.knowm.xchart.demo.charts.ohlc.OHLCChart01;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.OHLCStyler;
import org.knowm.xchart.style.Styler;

public class RealtimeChart06
implements ExampleChart<OHLCChart>,
RealtimeExampleChart {
    private OHLCChart ohlcChart;
    private List<Date> xData = new ArrayList<Date>();
    private List<Double> openData = new ArrayList<Double>();
    private List<Double> highData = new ArrayList<Double>();
    private List<Double> lowData = new ArrayList<Double>();
    private List<Double> closeData = new ArrayList<Double>();
    public static final String SERIES_NAME = "series1";

    public static void main(String[] args) {
        RealtimeChart06 realtimeChart01 = new RealtimeChart06();
        realtimeChart01.go();
    }

    private void go() {
        final SwingWrapper swingWrapper = new SwingWrapper((Chart)this.getChart());
        swingWrapper.displayChart();
        TimerTask chartUpdaterTask = new TimerTask(){

            @Override
            public void run() {
                RealtimeChart06.this.updateData();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        swingWrapper.repaintChart();
                    }
                });
            }
        };
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(chartUpdaterTask, 0L, 500L);
    }

    @Override
    public OHLCChart getChart() {
        this.ohlcChart = ((OHLCChartBuilder)((OHLCChartBuilder)((OHLCChartBuilder)((OHLCChartBuilder)new OHLCChartBuilder().width(800)).height(600)).title("Real-time Prices Chart")).theme(Styler.ChartTheme.Matlab)).build();
        ((OHLCStyler)this.ohlcChart.getStyler()).setLegendPosition(Styler.LegendPosition.OutsideS);
        ((OHLCStyler)this.ohlcChart.getStyler()).setLegendLayout(Styler.LegendLayout.Horizontal);
        OHLCChart01.populateData(this.xData, this.openData, this.highData, this.lowData, this.closeData);
        this.ohlcChart.addSeries(SERIES_NAME, this.xData, this.openData, this.highData, this.lowData, this.closeData);
        return this.ohlcChart;
    }

    @Override
    public void updateData() {
        OHLCChart01.populateData(this.xData.get(this.xData.size() - 1), this.closeData.get(this.closeData.size() - 1), 1, this.xData, this.openData, this.highData, this.lowData, this.closeData);
        while (this.xData.size() > 50) {
            this.xData.remove(0);
            this.openData.remove(0);
            this.highData.remove(0);
            this.lowData.remove(0);
            this.closeData.remove(0);
        }
        this.ohlcChart.updateOHLCSeries(SERIES_NAME, this.xData, this.openData, this.highData, this.lowData, this.closeData);
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Real-time OHLC Chart";
    }
}

