/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.scatter;

import java.util.LinkedList;
import java.util.Random;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class ScatterChart01
implements ExampleChart<XYChart> {
    public static void main(String[] args) {
        ScatterChart01 exampleChart = new ScatterChart01();
        XYChart chart = (XYChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    @Override
    public XYChart getChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).build();
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        ((XYStyler)chart.getStyler()).setChartTitleVisible(false);
        ((XYStyler)chart.getStyler()).setLegendVisible(false);
        ((XYStyler)chart.getStyler()).setMarkerSize(16);
        ((XYStyler)chart.getStyler()).setYAxisGroupPosition(0, Styler.YAxisPosition.Right);
        LinkedList<Double> xData = new LinkedList<Double>();
        LinkedList<Double> yData = new LinkedList<Double>();
        Random random = new Random();
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            xData.add(random.nextGaussian() / 1000.0);
            yData.add(-1000000.0 + random.nextGaussian());
        }
        XYSeries series = chart.addSeries("Gaussian Blob", xData, yData);
        series.setMarker(SeriesMarkers.CROSS);
        return chart;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Gaussian Blob with Y Axis on Right";
    }
}

