/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.scatter;

import java.awt.Color;
import java.util.ArrayList;
import org.knowm.xchart.AnnotationTextPanel;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Annotation;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class ScatterChart04
implements ExampleChart<XYChart> {
    public static void main(String[] args) {
        ScatterChart04 exampleChart = new ScatterChart04();
        XYChart chart = (XYChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    @Override
    public XYChart getChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title("ScatterChart04")).xAxisTitle("X").yAxisTitle("Y").build();
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        ((XYStyler)chart.getStyler()).setChartTitleVisible(false);
        ((XYStyler)chart.getStyler()).setLegendVisible(false);
        ((XYStyler)chart.getStyler()).setAxisTitlesVisible(false);
        ((XYStyler)chart.getStyler()).setXAxisDecimalPattern("0.0000000");
        chart.addAnnotation((Annotation)new AnnotationTextPanel("Here are some words in an AnnotationTextPanel!", 40.0, 40.0, true));
        chart.addAnnotation((Annotation)new AnnotationTextPanel("Here are some additional words", 4.0E-6, 4.0, false));
        chart.addAnnotation((Annotation)new AnnotationTextPanel("Here are some additional words \n in the upper right-hand corner \n with multiple lines", 800.0, 600.0, true));
        int size = 10;
        ArrayList<Double> xData = new ArrayList<Double>();
        ArrayList<Double> yData = new ArrayList<Double>();
        ArrayList<Double> errorBars = new ArrayList<Double>();
        for (int i = 0; i <= size; ++i) {
            xData.add((double)i / 1000000.0);
            yData.add(10.0 * Math.exp(-i));
            errorBars.add(Math.random() + 0.3);
        }
        XYSeries series = chart.addSeries("10^(-x)", xData, yData, errorBars);
        series.setMarkerColor(Color.RED);
        series.setMarker(SeriesMarkers.SQUARE);
        return chart;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Error Bars";
    }
}

