/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.theme;

import java.util.ArrayList;
import java.util.List;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class ThemeChart03
implements ExampleChart<XYChart> {
    public static void main(String[] args) {
        ThemeChart03 exampleChart = new ThemeChart03();
        XYChart chart = (XYChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    @Override
    public XYChart getChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).theme(Styler.ChartTheme.Matlab)).title("Matlab Theme")).xAxisTitle("X").yAxisTitle("Y").build();
        ((XYStyler)chart.getStyler()).setPlotGridLinesVisible(false);
        ((XYStyler)chart.getStyler()).setXAxisTickMarkSpacingHint(100);
        ((XYStyler)chart.getStyler()).setToolTipsEnabled(true);
        ArrayList<Integer> xData = new ArrayList<Integer>();
        for (int i = 0; i < 640; ++i) {
            xData.add(i);
        }
        List<Double> y1Data = this.getYAxis(xData, 320.0, 160.0);
        List<Double> y2Data = this.getYAxis(xData, 320.0, 320.0);
        ArrayList<Double> y3Data = new ArrayList<Double>(xData.size());
        for (int i = 0; i < 640; ++i) {
            y3Data.add(y1Data.get(i) - y2Data.get(i));
        }
        XYSeries series = chart.addSeries("Gaussian 1", xData, y1Data);
        series.setMarker(SeriesMarkers.NONE);
        series = chart.addSeries("Gaussian 2", xData, y2Data);
        series.setMarker(SeriesMarkers.NONE);
        series.setYAxisGroup(1);
        series = chart.addSeries("Difference", xData, y3Data);
        series.setMarker(SeriesMarkers.NONE);
        ((XYStyler)chart.getStyler()).setYAxisGroupPosition(1, Styler.YAxisPosition.Right);
        ((XYStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideS);
        return chart;
    }

    private List<Double> getYAxis(List<Integer> xData, double mean, double std) {
        ArrayList<Double> yData = new ArrayList<Double>(xData.size());
        for (Integer integer : xData) {
            yData.add(1.0 / (std * Math.sqrt(Math.PI * 2)) * Math.exp(-(((double)integer.intValue() - mean) * ((double)integer.intValue() - mean) / (2.0 * std * std))));
        }
        return yData;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Matlab Theme";
    }
}

