/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.standalone.issues;

import java.io.IOException;
import java.util.Random;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;

public class TestForIssue390 {
    public static void main(String[] args) throws IOException {
        Random rand = new Random();
        double min = 0.0;
        double max = 20.0;
        int nbServices = 20;
        int nbInstances = 50;
        long s = 24L;
        rand.setSeed(s);
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(600)).height(400)).title("Augmentation du cout induit par livraison express")).xAxisTitle("Proportion de colis express").yAxisTitle("Rapport cout/cout_opt").build();
        ((XYStyler)chart.getStyler()).setLegendVisible(true);
        ((XYStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideSW);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line);
        double[] xData = new double[nbServices];
        for (int i = 0; i < xData.length; ++i) {
            xData[i] = (double)(i + 1) / (double)nbServices;
        }
        double[][] results = new double[3][nbServices];
        for (int t = 0; t < 3; ++t) {
            System.out.print("Simulations pour t=" + (double)(t + 1) * 0.25 + "\n");
            for (int n = 1; n < nbServices + 1; ++n) {
                results[t][n - 1] = 1.2;
            }
            chart.addSeries(Double.toString(t), xData, results[t]);
            System.out.print(results[t][0] + " " + results[t][nbServices - 1] + "\n");
        }
        new SwingWrapper((Chart)chart).displayChart();
        BitmapEncoder.saveBitmap((Chart)chart, (String)"./Sample_Chart", (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
    }
}

