/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.standalone.issues;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.CategoryChartBuilder;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.Styler;

public class TestForIssue530 {
    public static final SimpleDateFormat sdfMonthYear = new SimpleDateFormat("MM/yyyy");

    public static void main(String[] args) {
        try {
            new SwingWrapper((Chart)TestForIssue530.getVolumesChart()).displayChart();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static CategoryChart getVolumesChart() throws Exception {
        List<Date> xSerie = null;
        CategoryChart chart = ((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)new CategoryChartBuilder().width(800)).height(500)).title("Volumes")).xAxisTitle("P\u00e9riode").yAxisTitle("Volumes").build();
        CategoryStyler styler = (CategoryStyler)chart.getStyler();
        styler.setLegendPosition(Styler.LegendPosition.InsideNW);
        styler.setLegendBackgroundColor(Color.DARK_GRAY);
        styler.setDatePattern("MM/yyyy");
        styler.setXAxisTickMarkSpacingHint(50);
        styler.setAntiAlias(true);
        styler.setChartTitleBoxBorderColor(Color.LIGHT_GRAY);
        styler.setToolTipsEnabled(true);
        styler.setOverlapped(false);
        styler.setStacked(true);
        styler.setChartBackgroundColor(Color.DARK_GRAY);
        styler.setChartFontColor(Color.LIGHT_GRAY);
        styler.setAxisTickLabelsColor(Color.LIGHT_GRAY);
        styler.setYAxisMax(Double.valueOf(100.0));
        for (int i = 0; i < 3; ++i) {
            List<Date> dataX = TestForIssue530.getSampleDataX(i);
            List<Double> dataY = TestForIssue530.getSampleDataY(i);
            if (xSerie == null) {
                xSerie = dataX;
            }
            CategorySeries serie = chart.addSeries("Serie " + i, xSerie, dataY);
            serie.setChartCategorySeriesRenderStyle(CategorySeries.CategorySeriesRenderStyle.Bar);
            System.out.println("Arrays.toString(dataY.toArray() = " + Arrays.toString(dataY.toArray()));
        }
        return chart;
    }

    public static List<Date> getSampleDataX(int i) throws Exception {
        CopyOnWriteArrayList<Date> xData = new CopyOnWriteArrayList<Date>();
        xData.add(sdfMonthYear.parse("09/2020"));
        xData.add(sdfMonthYear.parse("10/2020"));
        xData.add(sdfMonthYear.parse("11/2020"));
        return xData;
    }

    public static List<Double> getSampleDataY(int i) throws Exception {
        CopyOnWriteArrayList<Double> yData = new CopyOnWriteArrayList<Double>();
        yData.add(Double.valueOf(20 + i));
        yData.add(Double.valueOf(10 + i));
        yData.add(Double.valueOf(30 + i));
        return yData;
    }
}

