/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.standalone.issues;

import java.util.ArrayList;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;

public class TestForIssue54_2 {
    static final int WIDTH = 465;
    static final int HEIGHT = 320;

    public static void main(String[] args) {
        Chart chart = TestForIssue54_2.getLineChart();
        chart.setTitle("sin(x) on second axis with title");
        Series series = (Series)chart.getSeriesMap().get("y=sin(x)");
        series.setYAxisGroup(1);
        chart.getStyler().setYAxisGroupPosition(1, Styler.YAxisPosition.Left);
        chart.getStyler().setYAxisGroupPosition(0, Styler.YAxisPosition.Right);
        chart.setYAxisGroupTitle(1, "sin(x)");
        new SwingWrapper(chart).displayChart();
    }

    static Chart getLineChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(465)).height(320)).xAxisTitle("X").yAxisTitle("Y").build();
        ((XYStyler)chart.getStyler()).setToolTipsEnabled(true);
        ((XYStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideNW);
        int size = 30;
        ArrayList<Integer> xData = new ArrayList<Integer>();
        ArrayList<Double> yData = new ArrayList<Double>();
        ArrayList<Integer> xData2 = new ArrayList<Integer>();
        ArrayList<Double> yData2 = new ArrayList<Double>();
        for (int i = 0; i <= size; ++i) {
            double radians = Math.PI / (double)(size / 2) * (double)i;
            int x = i - size / 2;
            xData.add(x);
            yData.add(-1.0 * Math.sin(radians));
            xData2.add(x);
            yData2.add(-10.0 * Math.cos(radians));
        }
        chart.addSeries("y=sin(x)", xData, yData);
        chart.addSeries("y=cos(x)", xData2, yData2);
        return chart;
    }
}

