/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.jblake2;

import java.util.Arrays;
import org.kocakosm.jblake2.Blake2;
import org.kocakosm.jblake2.LittleEndian;
import org.kocakosm.jblake2.Preconditions;

public final class Blake2s
implements Blake2 {
    private static final int BLOCK_LENGTH = 64;
    private static final int[] IV = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final int[][] SIGMA = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}, {11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4}, {7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8}, {9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13}, {2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9}, {12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11}, {13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10}, {6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5}, {10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0}};
    private final int digestLength;
    private final byte[] buffer;
    private byte[] key;
    private int[] h;
    private int t0;
    private int t1;
    private int c;

    public Blake2s(int digestLength) {
        this(digestLength, new byte[0]);
    }

    public Blake2s(int digestLength, byte[] key) {
        Preconditions.checkArgument(key.length <= 32);
        Preconditions.checkArgument(digestLength >= 1 && digestLength <= 32);
        this.buffer = new byte[64];
        this.key = Arrays.copyOf(key, key.length);
        this.digestLength = digestLength;
        this.reset();
    }

    private Blake2s(Blake2s digest) {
        this.c = digest.c;
        this.buffer = Arrays.copyOf(digest.buffer, digest.buffer.length);
        this.key = Arrays.copyOf(digest.key, digest.key.length);
        this.digestLength = digest.digestLength;
        this.h = Arrays.copyOf(digest.h, digest.h.length);
        this.t0 = digest.t0;
        this.t1 = digest.t1;
    }

    @Override
    public String algorithm() {
        return "BLAKE2s";
    }

    @Override
    public void burn() {
        Arrays.fill(this.key, (byte)0);
        Arrays.fill(this.buffer, (byte)0);
        this.key = new byte[0];
        this.reset();
    }

    @Override
    public Blake2s copy() {
        return new Blake2s(this);
    }

    @Override
    public int length() {
        return this.digestLength;
    }

    @Override
    public Blake2s reset() {
        this.t0 = 0;
        this.t1 = 0;
        this.h = Arrays.copyOf(IV, IV.length);
        this.h[0] = this.h[0] ^ (this.digestLength | this.key.length << 8 | 0x1010000);
        if (this.key.length > 0) {
            System.arraycopy(this.key, 0, this.buffer, 0, this.key.length);
            Arrays.fill(this.buffer, this.key.length, 64, (byte)0);
            this.c = 64;
        } else {
            this.c = 0;
        }
        return this;
    }

    @Override
    public Blake2s update(byte input) {
        if (this.c == 64) {
            this.processBuffer(false);
        }
        this.buffer[this.c++] = input;
        return this;
    }

    @Override
    public Blake2s update(byte ... input) {
        return this.update(input, 0, input.length);
    }

    @Override
    public Blake2s update(byte[] input, int off, int len) {
        Preconditions.checkBounds(input, off, len);
        int index = off;
        int remaining = len;
        while (remaining > 0) {
            if (this.c == 64) {
                this.processBuffer(false);
            }
            int cpLen = Math.min(64 - this.c, remaining);
            System.arraycopy(input, index, this.buffer, this.c, cpLen);
            remaining -= cpLen;
            index += cpLen;
            this.c += cpLen;
        }
        return this;
    }

    @Override
    public byte[] digest() {
        int i;
        Arrays.fill(this.buffer, this.c, 64, (byte)0);
        this.processBuffer(true);
        byte[] out = new byte[this.digestLength];
        for (i = 0; i < this.h.length && i * 4 < this.digestLength - 4; ++i) {
            LittleEndian.encode(this.h[i], out, i * 4);
        }
        byte[] last = LittleEndian.encode(this.h[i]);
        System.arraycopy(last, 0, out, i * 4, this.digestLength - i * 4);
        this.reset();
        return out;
    }

    private void processBuffer(boolean lastBlock) {
        this.t0 += this.c;
        if (this.t0 == 0 && this.c > 0) {
            ++this.t1;
            Preconditions.checkState(this.t1 != 0);
        }
        this.c = 0;
        this.F(this.buffer, lastBlock);
    }

    private void F(byte[] input, boolean lastBlock) {
        int i;
        int[] v = new int[16];
        System.arraycopy(this.h, 0, v, 0, this.h.length);
        System.arraycopy(IV, 0, v, this.h.length, IV.length);
        v[12] = v[12] ^ this.t0;
        v[13] = v[13] ^ this.t1;
        if (lastBlock) {
            v[14] = ~v[14];
        }
        int[] m = new int[16];
        for (int j = 0; j < 16; ++j) {
            m[j] = LittleEndian.decodeInt(input, j * 4);
        }
        for (i = 0; i < 10; ++i) {
            this.G(v, 0, 4, 8, 12, m[SIGMA[i][0]], m[SIGMA[i][1]]);
            this.G(v, 1, 5, 9, 13, m[SIGMA[i][2]], m[SIGMA[i][3]]);
            this.G(v, 2, 6, 10, 14, m[SIGMA[i][4]], m[SIGMA[i][5]]);
            this.G(v, 3, 7, 11, 15, m[SIGMA[i][6]], m[SIGMA[i][7]]);
            this.G(v, 0, 5, 10, 15, m[SIGMA[i][8]], m[SIGMA[i][9]]);
            this.G(v, 1, 6, 11, 12, m[SIGMA[i][10]], m[SIGMA[i][11]]);
            this.G(v, 2, 7, 8, 13, m[SIGMA[i][12]], m[SIGMA[i][13]]);
            this.G(v, 3, 4, 9, 14, m[SIGMA[i][14]], m[SIGMA[i][15]]);
        }
        for (i = 0; i < this.h.length; ++i) {
            int n = i;
            this.h[n] = this.h[n] ^ (v[i] ^ v[i + 8]);
        }
    }

    private void G(int[] v, int a, int b, int c, int d, int x, int y) {
        int n = a;
        v[n] = v[n] + (v[b] + x);
        v[d] = Integer.rotateRight(v[d] ^ v[a], 16);
        int n2 = c;
        v[n2] = v[n2] + v[d];
        v[b] = Integer.rotateRight(v[b] ^ v[c], 12);
        int n3 = a;
        v[n3] = v[n3] + (v[b] + y);
        v[d] = Integer.rotateRight(v[d] ^ v[a], 8);
        int n4 = c;
        v[n4] = v[n4] + v[d];
        v[b] = Integer.rotateRight(v[b] ^ v[c], 7);
    }
}

