/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.ajp.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import javax.net.SocketFactory;
import org.kohsuke.ajp.client.TesterAjpMessage;

public class SimpleAjpClient {
    private static final int AJP_PACKET_SIZE = 8192;
    private static final byte[] AJP_CPING;
    private String host = "localhost";
    private int port = -1;
    private Socket socket = null;

    public int getPort() {
        return this.port;
    }

    public void connect(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        this.socket = SocketFactory.getDefault().createSocket(host, port);
    }

    public void disconnect() throws IOException {
        this.socket.close();
        this.socket = null;
    }

    public TesterAjpMessage createForwardMessage(String url) {
        return this.createForwardMessage(url, 2);
    }

    public TesterAjpMessage createForwardMessage(String url, int method) {
        TesterAjpMessage message = new TesterAjpMessage(8192);
        message.reset();
        message.getBuffer()[0] = 18;
        message.getBuffer()[1] = 52;
        message.appendByte(2);
        message.appendByte(method);
        message.appendString("http");
        message.appendString(url);
        message.appendString("10.0.0.1");
        message.appendString("client.dev.local");
        message.appendString(this.host);
        message.appendInt(this.port);
        message.appendByte(0);
        return message;
    }

    public TesterAjpMessage createBodyMessage(byte[] data) {
        TesterAjpMessage message = new TesterAjpMessage(8192);
        message.reset();
        message.getBuffer()[0] = 18;
        message.getBuffer()[1] = 52;
        message.appendBytes(data, 0, data.length);
        message.end();
        return message;
    }

    public TesterAjpMessage sendMessage(TesterAjpMessage headers) throws IOException {
        return this.sendMessage(headers, null);
    }

    public TesterAjpMessage sendMessage(TesterAjpMessage headers, TesterAjpMessage body) throws IOException {
        this.socket.getOutputStream().write(headers.getBuffer(), 0, headers.getLen());
        if (body != null) {
            this.socket.getOutputStream().write(body.getBuffer(), 0, body.getLen());
        }
        return this.readMessage();
    }

    public TesterAjpMessage cping() throws IOException {
        this.socket.getOutputStream().write(AJP_CPING);
        return this.readMessage();
    }

    public TesterAjpMessage readMessage() throws IOException {
        InputStream is = this.socket.getInputStream();
        TesterAjpMessage message = new TesterAjpMessage(8192);
        byte[] buf = message.getBuffer();
        int headerLength = message.getHeaderLength();
        this.read(is, buf, 0, headerLength);
        int messageLength = message.processHeader(false);
        if (messageLength < 0) {
            throw new IOException("Invalid AJP message length");
        }
        if (messageLength == 0) {
            return message;
        }
        if (messageLength > buf.length) {
            throw new IllegalArgumentException("Message too long [" + Integer.valueOf(messageLength) + "] for buffer length [" + Integer.valueOf(buf.length) + "]");
        }
        this.read(is, buf, headerLength, messageLength);
        return message;
    }

    protected boolean read(InputStream is, byte[] buf, int pos, int n) throws IOException {
        int res = 0;
        for (int read = 0; read < n; read += res) {
            res = is.read(buf, read + pos, n - read);
            if (res > 0) {
                continue;
            }
            throw new IOException("Read failed");
        }
        return true;
    }

    static {
        TesterAjpMessage ajpCping = new TesterAjpMessage(16);
        ajpCping.reset();
        ajpCping.appendByte(10);
        ajpCping.end();
        AJP_CPING = new byte[ajpCping.getLen()];
        System.arraycopy(ajpCping.getBuffer(), 0, AJP_CPING, 0, ajpCping.getLen());
    }
}

