/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.RateLimitChecker;

class GitHubRateLimitChecker {
    @Nonnull
    private final RateLimitChecker core;
    @Nonnull
    private final RateLimitChecker search;
    @Nonnull
    private final RateLimitChecker graphql;
    @Nonnull
    private final RateLimitChecker integrationManifest;

    GitHubRateLimitChecker() {
        this(RateLimitChecker.NONE, RateLimitChecker.NONE, RateLimitChecker.NONE, RateLimitChecker.NONE);
    }

    GitHubRateLimitChecker(@Nonnull RateLimitChecker core, @Nonnull RateLimitChecker search, @Nonnull RateLimitChecker graphql, @Nonnull RateLimitChecker integrationManifest) {
        this.core = Objects.requireNonNull(core);
        assert (search == RateLimitChecker.NONE);
        assert (graphql == RateLimitChecker.NONE);
        assert (integrationManifest == RateLimitChecker.NONE);
        this.search = Objects.requireNonNull(search);
        this.graphql = Objects.requireNonNull(graphql);
        this.integrationManifest = Objects.requireNonNull(integrationManifest);
    }

    void checkRateLimit(GitHubClient client, GitHubRequest request) throws IOException {
        RateLimitChecker guard = this.selectChecker(request.urlPath());
        if (guard == RateLimitChecker.NONE) {
            return;
        }
        GHRateLimit rateLimit = client.rateLimit();
        GHRateLimit.Record rateLimitRecord = rateLimit.getRecordForUrlPath(request.urlPath());
        long waitCount = 0L;
        try {
            while (guard.checkRateLimit(rateLimitRecord, waitCount)) {
                ++waitCount;
                Thread.sleep(1000L);
                rateLimit = client.getRateLimit();
                rateLimitRecord = rateLimit.getRecordForUrlPath(request.urlPath());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException(e.getMessage()).initCause(e);
        }
    }

    @Nonnull
    private RateLimitChecker selectChecker(@Nonnull String urlPath) {
        if (urlPath.equals("/rate_limit")) {
            return RateLimitChecker.NONE;
        }
        if (urlPath.startsWith("/search")) {
            return this.search;
        }
        if (urlPath.startsWith("/graphql")) {
            return this.graphql;
        }
        if (urlPath.startsWith("/app-manifests")) {
            return this.integrationManifest;
        }
        return this.core;
    }
}

