/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
public class GHCommitComment
extends GHObject {
    private GHRepository owner;
    String body;
    String html_url;
    String commit_id;
    Integer line;
    String path;
    User user;

    public GHRepository getOwner() {
        return this.owner;
    }

    public URL getHtmlUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public String getSHA1() {
        return this.commit_id;
    }

    public String getBody() {
        return this.body;
    }

    public String getPath() {
        return this.path;
    }

    public int getLine() {
        return this.line != null ? this.line : -1;
    }

    public GHUser getUser() throws IOException {
        return this.owner.root.getUser(this.user.login);
    }

    public GHCommit getCommit() throws IOException {
        return this.getOwner().getCommit(this.getSHA1());
    }

    public void update(String body) throws IOException {
        new Requester(this.owner.root).with("body", body).method("PATCH").to(this.getApiTail(), GHCommitComment.class);
        this.body = body;
    }

    public void delete() throws IOException {
        new Requester(this.owner.root).method("DELETE").to(this.getApiTail());
    }

    private String getApiTail() {
        return String.format("/repos/%s/%s/comments/%s", this.owner.getOwnerName(), this.owner.getName(), this.id);
    }

    GHCommitComment wrap(GHRepository owner) {
        this.owner = owner;
        return this;
    }

    static class User {
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String url;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String avatar_url;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String gravatar_id;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        int id;
        String login;

        User() {
        }
    }
}

