/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework.adjunct;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.adjunct.Adjunct;

public class AdjunctManager {
    private final ConcurrentHashMap<String, Adjunct> adjuncts = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> allowedResources = new ConcurrentHashMap();
    private final ClassLoader classLoader;
    public final String rootURL;
    private static final String KEY = AdjunctManager.class.getName();

    public AdjunctManager(ServletContext context, ClassLoader classLoader, String rootURL) {
        this.classLoader = classLoader;
        this.rootURL = rootURL;
        context.setAttribute(KEY, (Object)this);
    }

    public static AdjunctManager get(ServletContext context) {
        return (AdjunctManager)context.getAttribute(KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Adjunct get(String name) throws IOException {
        Adjunct a = this.adjuncts.get(name);
        if (a != null) {
            return a;
        }
        AdjunctManager adjunctManager = this;
        synchronized (adjunctManager) {
            a = this.adjuncts.get(name);
            if (a != null) {
                return a;
            }
            a = new Adjunct(this, name, this.classLoader);
            this.adjuncts.put(name, a);
            return a;
        }
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        URL res;
        String path = req.getRestOfPath();
        if (!this.allowedResources.containsKey(path)) {
            if (!this.allowResourceToBeServed(path)) {
                rsp.sendError(403);
                return;
            }
            this.allowedResources.put(path, path);
        }
        if ((res = this.classLoader.getResource(path)) == null) {
            throw HttpResponses.error((int)404, (Throwable)new IllegalArgumentException("No such adjunct found: " + path));
        }
        long expires = MetaClass.NO_CACHE ? 0L : 86400000L;
        rsp.serveFile(req, res, expires);
    }

    protected boolean allowResourceToBeServed(String absolutePath) {
        return absolutePath.endsWith(".gif") || absolutePath.endsWith(".png") || absolutePath.endsWith(".css") || absolutePath.endsWith(".js");
    }
}

