/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework.adjunct;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.jelly.XMLOutput;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.framework.adjunct.Adjunct;
import org.kohsuke.stapler.framework.adjunct.AdjunctManager;
import org.kohsuke.stapler.framework.adjunct.NoSuchAdjunctException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdjunctsInPage {
    private final AdjunctManager manager;
    private final Set<String> included = new HashSet<String>();
    private final List<Adjunct> pending = new ArrayList<Adjunct>();
    private final StaplerRequest request;
    private static final String KEY = AdjunctsInPage.class.getName();

    public static AdjunctsInPage get() {
        return AdjunctsInPage.get(Stapler.getCurrentRequest());
    }

    public static AdjunctsInPage get(StaplerRequest request) {
        AdjunctsInPage aip = (AdjunctsInPage)request.getAttribute(KEY);
        if (aip == null) {
            aip = new AdjunctsInPage(AdjunctManager.get(request.getServletContext()), request);
            request.setAttribute(KEY, (Object)aip);
        }
        return aip;
    }

    private AdjunctsInPage(AdjunctManager manager, StaplerRequest request) {
        this.manager = manager;
        this.request = request;
    }

    public void generate(XMLOutput out, String ... includes) throws IOException, SAXException {
        ArrayList<Adjunct> needed = new ArrayList<Adjunct>();
        for (String include : includes) {
            this.findNeeded(include, needed);
        }
        for (Adjunct adj : needed) {
            adj.write(this.request, out);
        }
    }

    public void spool(String ... includes) throws IOException, SAXException {
        for (String include : includes) {
            this.findNeeded(include, this.pending);
        }
    }

    public void writeSpooled(XMLOutput out) throws SAXException, IOException {
        for (Adjunct adj : this.pending) {
            adj.write(this.request, out);
        }
        this.pending.clear();
    }

    private void findNeeded(String include, List<Adjunct> needed) throws IOException {
        if (!this.included.add(include)) {
            return;
        }
        try {
            Adjunct a = this.manager.get(include);
            for (String req : a.required) {
                this.findNeeded(req, needed);
            }
            needed.add(a);
        }
        catch (NoSuchAdjunctException noSuchAdjunctException) {
            // empty catch block
        }
    }
}

