/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.DynamicTag;
import org.apache.commons.jelly.impl.TagFactory;
import org.apache.commons.jelly.impl.TagScript;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.jelly.CustomJellyContext;
import org.kohsuke.stapler.jelly.JellyFacet;
import org.kohsuke.stapler.jelly.JellyTagFileLoader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class CustomTagLibrary
extends TagLibrary {
    private final JellyContext master;
    private final ClassLoader classLoader;
    public final MetaClassLoader metaClassLoader;
    public final String nsUri;
    public final String basePath;
    private final Map<String, Script> scripts = new Hashtable<String, Script>();
    private final List<JellyTagFileLoader> loaders;

    public CustomTagLibrary(JellyContext master, ClassLoader classLoader, String nsUri, String basePath) {
        this.master = master;
        this.classLoader = classLoader;
        this.nsUri = nsUri;
        this.basePath = basePath;
        this.metaClassLoader = MetaClassLoader.get((ClassLoader)classLoader);
        this.loaders = JellyTagFileLoader.discover(classLoader);
    }

    public TagScript createTagScript(String name, Attributes attributes) throws JellyException {
        final Script s = this.load(name);
        if (s == null) {
            return null;
        }
        return new TagScript(new TagFactory(){

            public Tag createTag(String name, Attributes attributes) {
                return CustomTagLibrary.this.createTag(name, s);
            }
        });
    }

    public Tag createTag(String name, Attributes attributes) throws JellyException {
        Script s = this.load(name);
        if (s == null) {
            return null;
        }
        return this.createTag(name, s);
    }

    private Tag createTag(String tagName, Script s) {
        if (JellyFacet.TRACE) {
            final String source = "{jelly:" + this.nsUri + "}:" + tagName;
            return new StaplerDynamicTag(this.nsUri, tagName, s){

                public void doTag(XMLOutput output) throws JellyTagException {
                    try {
                        String msg = "<" + source + ">";
                        output.comment(msg.toCharArray(), 0, msg.length());
                        super.doTag(output);
                        msg = "</" + source + ">";
                        output.comment(msg.toCharArray(), 0, msg.length());
                    }
                    catch (SAXException e) {
                        throw new JellyTagException((Throwable)e);
                    }
                }
            };
        }
        return new StaplerDynamicTag(this.nsUri, tagName, s);
    }

    private Script load(String name) throws JellyException {
        Script script = this.scripts.get(name);
        if (script != null && !MetaClass.NO_CACHE) {
            return script;
        }
        script = null;
        if (MetaClassLoader.debugLoader != null) {
            script = this.load(name, MetaClassLoader.debugLoader.loader);
        }
        if (script == null) {
            script = this.load(name, this.classLoader);
        }
        return script;
    }

    private Script load(String name, ClassLoader classLoader) throws JellyException {
        URL res = classLoader.getResource(this.basePath + '/' + name + ".jelly");
        if (res != null) {
            Script script = this.loadJellyScript(res);
            this.scripts.put(name, script);
            return script;
        }
        for (JellyTagFileLoader loader : this.loaders) {
            Script s = loader.load(this, name, classLoader);
            if (s == null) continue;
            this.scripts.put(name, s);
            return s;
        }
        return null;
    }

    private Script loadJellyScript(URL res) throws JellyException {
        CustomJellyContext context = new CustomJellyContext(this.master);
        context.setClassLoader(this.classLoader);
        return context.compileScript(res);
    }

    public static class StaplerDynamicTag
    extends DynamicTag {
        private final String nsUri;
        private final String localName;

        public StaplerDynamicTag(String nsUri, String localName, Script template) {
            super(template);
            this.nsUri = nsUri;
            this.localName = localName;
        }

        public Script getBody() {
            final Script body = super.getBody();
            return new Script(){
                final JellyContext currentContext;
                {
                    this.currentContext = StaplerDynamicTag.this.getContext();
                }

                public Script compile() throws JellyException {
                    return this;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(JellyContext context, XMLOutput output) throws JellyTagException {
                    Map m = context.getVariables();
                    Object oldAttrs = m.put("attrs", this.currentContext.getVariable("attrs"));
                    try {
                        body.run(context, output);
                    }
                    finally {
                        m.put("attrs", oldAttrs);
                    }
                }
            };
        }

        public String getNsUri() {
            return this.nsUri;
        }

        public String getLocalName() {
            return this.localName;
        }
    }
}

