/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.TagScript;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.jelly.CustomJellyContext;
import org.kohsuke.stapler.jelly.ScriptInvoker;

public class DefaultScriptInvoker
implements ScriptInvoker {
    public void invokeScript(StaplerRequest req, StaplerResponse rsp, Script script, Object it) throws IOException, JellyTagException {
        XMLOutput xmlOutput = this.createXMLOutput(req, rsp, script, it);
        this.invokeScript(req, rsp, script, it, xmlOutput);
        xmlOutput.flush();
        xmlOutput.close();
    }

    public void invokeScript(StaplerRequest req, StaplerResponse rsp, Script script, Object it, XMLOutput out) throws IOException, JellyTagException {
        JellyContext context = this.createContext(req, rsp, script, it);
        this.exportVariables(req, rsp, script, it, context);
        script.run(context, out);
    }

    protected XMLOutput createXMLOutput(StaplerRequest req, StaplerResponse rsp, Script script, Object it) throws IOException {
        return XMLOutput.createXMLOutput((OutputStream)this.createOutputStream(req, rsp, script, it));
    }

    protected OutputStream createOutputStream(StaplerRequest req, StaplerResponse rsp, Script script, Object it) throws IOException {
        TagScript ts;
        OutputStream output = null;
        if (script instanceof TagScript && (ts = (TagScript)script).getLocalName().equals("compress")) {
            output = rsp.getCompressedOutputStream((HttpServletRequest)req);
        }
        if (output == null) {
            output = new BufferedOutputStream((OutputStream)rsp.getOutputStream());
        }
        output = new FilterOutputStream(output){

            public void flush() {
            }

            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }
        };
        return output;
    }

    protected void exportVariables(StaplerRequest req, StaplerResponse rsp, Script script, Object it, JellyContext context) {
        Enumeration en = req.getAttributeNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            context.setVariable(name, req.getAttribute(name));
        }
        context.setVariable("request", (Object)req);
        context.setVariable("response", (Object)rsp);
        context.setVariable("it", it);
        ServletContext servletContext = req.getServletContext();
        context.setVariable("servletContext", (Object)servletContext);
        context.setVariable("app", servletContext.getAttribute("app"));
        context.setVariable("requestScope", (Object)context.getVariables());
        context.setVariable("org.apache.commons.jelly.tags.fmt.locale", (Object)req.getLocale());
    }

    protected JellyContext createContext(StaplerRequest req, StaplerResponse rsp, Script script, Object it) {
        CustomJellyContext context = new CustomJellyContext();
        context.setClassLoader(req.getStapler().getWebApp().getClassLoader());
        return context;
    }
}

