/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionSupport;
import org.jvnet.localizer.LocaleProvider;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.jelly.InternationalizedStringExpressionListener;
import org.kohsuke.stapler.jelly.JellyClassLoaderTearOff;
import org.kohsuke.stapler.jelly.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternationalizedStringExpression
extends ExpressionSupport {
    public final ResourceBundle resourceBundle;
    private final Expression[] arguments;
    public final String key;
    public final String expressionText;
    private static final Expression[] EMPTY_ARGUMENTS = new Expression[0];
    private static final String LISTENER_NAME = InternationalizedStringExpressionListener.class.getName();

    public InternationalizedStringExpression(ResourceBundle resourceBundle, String text) throws JellyException {
        this.resourceBundle = resourceBundle;
        this.expressionText = text;
        if (!text.startsWith("%")) {
            throw new JellyException(text + " doesn't start with %");
        }
        int idx = (text = text.substring(1)).indexOf(40);
        if (idx < 0) {
            this.key = text;
            this.arguments = EMPTY_ARGUMENTS;
            return;
        }
        ArrayList<Expression> args = new ArrayList<Expression>();
        this.key = text.substring(0, idx);
        text = text.substring(idx + 1);
        while (text.length() > 0) {
            String token = this.tokenize(text);
            args.add(JellyClassLoaderTearOff.EXPRESSION_FACTORY.createExpression(token));
            text = text.substring(token.length() + 1);
        }
        this.arguments = args.toArray(new Expression[args.size()]);
    }

    public List<Expression> getArguments() {
        return Collections.unmodifiableList(Arrays.asList(this.arguments));
    }

    private String tokenize(String text) throws JellyException {
        int parenthesis = 0;
        block7: for (int idx = 0; idx < text.length(); ++idx) {
            char ch = text.charAt(idx);
            switch (ch) {
                case ',': {
                    if (parenthesis != 0) continue block7;
                    return text.substring(0, idx);
                }
                case '(': 
                case '[': 
                case '{': {
                    ++parenthesis;
                    continue block7;
                }
                case ')': {
                    if (parenthesis == 0) {
                        return text.substring(0, idx);
                    }
                }
                case ']': 
                case '}': {
                    --parenthesis;
                    continue block7;
                }
                case '\"': 
                case '\'': {
                    idx = text.indexOf(ch, idx + 1);
                }
            }
        }
        throw new JellyException(this.expressionText + " is missing ')' at the end");
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    public Object evaluate(JellyContext jellyContext) {
        Object[] args = new Object[this.arguments.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.arguments[i].evaluate(jellyContext);
        }
        InternationalizedStringExpressionListener listener = (InternationalizedStringExpressionListener)Stapler.getCurrentRequest().getAttribute(LISTENER_NAME);
        if (listener != null) {
            listener.onUsed(this, args);
        }
        return this.resourceBundle.format(LocaleProvider.getLocale(), this.key, args);
    }
}

