/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.TagScript;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.jelly.JellyClassTearOff;
import org.kohsuke.stapler.jelly.JellyFacet;
import org.xml.sax.SAXException;

public class IncludeTag
extends TagSupport {
    private Object it;
    private String page;
    private Object from;
    private boolean optional;
    private Class clazz;

    public void setPage(String page) {
        this.page = page;
    }

    public void setIt(Object it) {
        this.it = it;
    }

    public void setFrom(Object from) {
        this.from = from;
    }

    public void setClass(Class clazz) {
        this.clazz = clazz;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        Script script;
        if (this.page == null) {
            if (this.optional) {
                this.invokeBody(output);
                return;
            }
            throw new JellyTagException("The page attribute is not specified");
        }
        Object it = this.it;
        if (it == null) {
            it = this.getContext().getVariable("it");
        }
        MetaClass c = WebApp.getCurrent().getMetaClass(this.getScriptClass(it));
        try {
            script = (Script)((JellyClassTearOff)((Object)c.loadTearOff(JellyClassTearOff.class))).findScript(this.page);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JellyTagException("Error loading '" + this.page + "' for " + c.klass, (Throwable)e);
        }
        if (script == null) {
            if (this.optional) {
                this.invokeBody(output);
                return;
            }
            throw new JellyTagException("No page found '" + this.page + "' for " + c.klass);
        }
        this.context = new JellyContext(this.getContext());
        if (this.it != null) {
            this.context.setVariable("it", this.it);
        }
        this.context.setVariable("from", this.from != null ? this.from : it);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(c.classLoader.loader);
        try {
            String msg;
            String source = null;
            if (JellyFacet.TRACE) {
                if (script instanceof TagScript) {
                    TagScript ts = (TagScript)script;
                    source = ts.getFileName();
                } else {
                    source = this.page + " (exact source location unknown)";
                }
                msg = "\nBegin " + source + '\n';
                output.comment(msg.toCharArray(), 0, msg.length());
            }
            script.run(this.context, output);
            if (source != null) {
                msg = "\nEnd " + source + '\n';
                output.comment(msg.toCharArray(), 0, msg.length());
            }
        }
        catch (SAXException e) {
            throw new JellyTagException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private Class getScriptClass(Object it) {
        if (this.clazz != null) {
            return this.clazz;
        }
        if (this.from != null) {
            return this.from.getClass();
        }
        return it.getClass();
    }
}

