/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fastuuidparser;

import java.util.UUID;

public final class FastUuidParser {
    public static UUID fromString(String s) {
        if (s.length() != 36 || s.charAt(8) != '-' || s.charAt(13) != '-' || s.charAt(18) != '-' || s.charAt(23) != '-') {
            throw new IllegalArgumentException("Invalid UUID string: " + s);
        }
        long mostSigBits = FastUuidParser.parseHexStrToLong(s.substring(0, 8));
        mostSigBits <<= 16;
        mostSigBits |= FastUuidParser.parseHexStrToLong(s.substring(9, 13));
        mostSigBits <<= 16;
        long leastSigBits = FastUuidParser.parseHexStrToLong(s.substring(19, 23));
        leastSigBits <<= 48;
        return new UUID(mostSigBits |= FastUuidParser.parseHexStrToLong(s.substring(14, 18)), leastSigBits |= FastUuidParser.parseHexStrToLong(s.substring(24, 36)));
    }

    private static long parseHexStrToLong(String s) {
        long result = 0L;
        int i = 0;
        int len = s.length();
        while (i < len) {
            int digit;
            if ((digit = FastUuidParser.hexdigit(s.charAt(i++))) < 0) {
                throw new IllegalArgumentException("Invalid UUID string: " + s);
            }
            result <<= 4;
            result -= (long)digit;
        }
        return -result;
    }

    private static int hexdigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }
}

