/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.apache;

import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.LdapURL;
import org.ldaptive.provider.Provider;
import org.ldaptive.provider.ProviderConnectionFactory;
import org.ldaptive.provider.apache.ApacheLdapConnectionFactory;
import org.ldaptive.provider.apache.ApacheLdapProviderConfig;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.DefaultHostnameVerifier;
import org.ldaptive.ssl.DefaultSSLContextInitializer;
import org.ldaptive.ssl.HostnameVerifierConfig;
import org.ldaptive.ssl.HostnameVerifyingTrustManager;
import org.ldaptive.ssl.SSLContextInitializer;

public class ApacheLdapProvider
implements Provider<ApacheLdapProviderConfig> {
    private ApacheLdapProviderConfig config = new ApacheLdapProviderConfig();

    public ProviderConnectionFactory<ApacheLdapProviderConfig> getConnectionFactory(ConnectionConfig cc) {
        LdapConnectionConfig lcc = this.config.getLdapConnectionConfig();
        if (lcc == null) {
            lcc = this.getDefaultLdapConnectionConfig(cc);
        }
        return new ApacheLdapConnectionFactory(cc.getLdapUrl(), cc.getConnectionStrategy(), this.config, lcc, cc.getUseStartTLS(), cc.getResponseTimeout());
    }

    protected SSLContextInitializer getHostnameVerifierSSLContextInitializer(ConnectionConfig cc) {
        DefaultSSLContextInitializer contextInit;
        LdapURL ldapUrl = new LdapURL(cc.getLdapUrl());
        if (cc.getSslConfig() != null && !cc.getSslConfig().isEmpty()) {
            CredentialConfig credConfig = cc.getSslConfig().getCredentialConfig();
            TrustManager[] managers = cc.getSslConfig().getTrustManagers();
            CertificateHostnameVerifier verifier = cc.getSslConfig().getHostnameVerifier();
            if (credConfig != null) {
                try {
                    contextInit = credConfig.createSSLContextInitializer();
                }
                catch (GeneralSecurityException e) {
                    throw new IllegalArgumentException(e);
                }
            } else {
                contextInit = managers != null ? new DefaultSSLContextInitializer(false) : new DefaultSSLContextInitializer(true);
            }
            if (managers != null) {
                contextInit.setTrustManagers(managers);
            }
            if (verifier != null) {
                contextInit.setHostnameVerifierConfig(new HostnameVerifierConfig(verifier, ldapUrl.getHostnames()));
            } else {
                contextInit.setHostnameVerifierConfig(new HostnameVerifierConfig((CertificateHostnameVerifier)new DefaultHostnameVerifier(), ldapUrl.getHostnames()));
            }
        } else {
            contextInit = new DefaultSSLContextInitializer(true);
            contextInit.setTrustManagers(new TrustManager[]{new HostnameVerifyingTrustManager((CertificateHostnameVerifier)new DefaultHostnameVerifier(), ldapUrl.getHostnames())});
        }
        return contextInit;
    }

    protected LdapConnectionConfig getDefaultLdapConnectionConfig(ConnectionConfig cc) {
        LdapConnectionConfig lcc = new LdapConnectionConfig();
        if (cc.getUseStartTLS() || cc.getUseSSL() || cc.getLdapUrl().toLowerCase().contains("ldaps://")) {
            KeyManager[] keyManagers;
            TrustManager[] trustManagers;
            SSLContextInitializer contextInit = this.getHostnameVerifierSSLContextInitializer(cc);
            try {
                trustManagers = contextInit.getTrustManagers();
                keyManagers = contextInit.getKeyManagers();
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException(e);
            }
            lcc.setUseSsl(cc.getUseSSL() || cc.getLdapUrl().toLowerCase().contains("ldaps://"));
            lcc.setTrustManagers(trustManagers);
            lcc.setKeyManagers(keyManagers);
            if (cc.getSslConfig() != null && cc.getSslConfig().getEnabledCipherSuites() != null) {
                lcc.setEnabledCipherSuites(cc.getSslConfig().getEnabledCipherSuites());
            }
            if (cc.getSslConfig() != null && cc.getSslConfig().getEnabledProtocols() != null) {
                lcc.setSslProtocol(cc.getSslConfig().getEnabledProtocols()[0]);
            }
        }
        return lcc;
    }

    public ApacheLdapProviderConfig getProviderConfig() {
        return this.config;
    }

    public void setProviderConfig(ApacheLdapProviderConfig pc) {
        this.config = pc;
    }

    public ApacheLdapProvider newInstance() {
        return new ApacheLdapProvider();
    }
}

