/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.spring.parser;

import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.BindAuthenticationHandler;
import org.ldaptive.auth.PooledBindAuthenticationHandler;
import org.ldaptive.auth.ext.ActiveDirectoryAuthenticationResponseHandler;
import org.ldaptive.auth.ext.EDirectoryAuthenticationResponseHandler;
import org.ldaptive.auth.ext.FreeIPAAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordExpirationAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordPolicyAuthenticationResponseHandler;
import org.ldaptive.beans.spring.parser.AbstractConnectionPoolBeanDefinitionParser;
import org.ldaptive.control.PasswordPolicyControl;
import org.ldaptive.pool.PooledConnectionFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public abstract class AbstractAuthenticatorBeanDefinitionParser
extends AbstractConnectionPoolBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return Authenticator.class;
    }

    protected BeanDefinitionBuilder parseAuthHandler(Element element) {
        BeanDefinitionBuilder authHandler;
        if (element.getAttribute("disablePooling") != null && Boolean.valueOf(element.getAttribute("disablePooling")).booleanValue()) {
            authHandler = BeanDefinitionBuilder.genericBeanDefinition(BindAuthenticationHandler.class);
            authHandler.addPropertyValue("connectionFactory", (Object)this.parseDefaultConnectionFactory(null, element, false).getBeanDefinition());
        } else {
            String name = "bind-pool";
            if (element.hasAttribute("id")) {
                name = element.getAttribute("id") + "-bind-pool";
            }
            authHandler = BeanDefinitionBuilder.genericBeanDefinition(PooledBindAuthenticationHandler.class);
            BeanDefinitionBuilder connectionFactory = BeanDefinitionBuilder.genericBeanDefinition(PooledConnectionFactory.class);
            connectionFactory.addPropertyValue("connectionPool", (Object)this.parseConnectionPool(null, name, element, false).getBeanDefinition());
            authHandler.addPropertyValue("connectionFactory", (Object)connectionFactory.getBeanDefinition());
        }
        return authHandler;
    }

    protected BeanDefinitionBuilder parseAuthResponseHandler(BeanDefinitionBuilder authenticator, BeanDefinitionBuilder authHandler, Element element) {
        BeanDefinitionBuilder responseHandler = null;
        BeanDefinitionBuilder requestControls = null;
        Element handlerElement = AbstractAuthenticatorBeanDefinitionParser.getDirectChild(AbstractAuthenticatorBeanDefinitionParser.getDirectChild(element, "authentication-response-handler"), "password-policy-handler", "password-expiration-handler", "e-directory-handler", "free-ipa-handler", "active-directory-handler");
        if (handlerElement != null) {
            switch (handlerElement.getLocalName()) {
                case "password-policy-handler": {
                    responseHandler = BeanDefinitionBuilder.genericBeanDefinition(PasswordPolicyAuthenticationResponseHandler.class);
                    requestControls = BeanDefinitionBuilder.genericBeanDefinition(PasswordPolicyControl.class);
                    break;
                }
                case "password-expiration-handler": {
                    responseHandler = BeanDefinitionBuilder.genericBeanDefinition(PasswordExpirationAuthenticationResponseHandler.class);
                    break;
                }
                case "e-directory-handler": {
                    responseHandler = BeanDefinitionBuilder.genericBeanDefinition(EDirectoryAuthenticationResponseHandler.class);
                    if (handlerElement.hasAttribute("warningPeriod")) {
                        BeanDefinitionBuilder period = BeanDefinitionBuilder.rootBeanDefinition(AbstractAuthenticatorBeanDefinitionParser.class, (String)"parsePeriod");
                        period.addConstructorArgValue((Object)handlerElement.getAttribute("warningPeriod"));
                        responseHandler.addPropertyValue("warningPeriod", (Object)period.getBeanDefinition());
                    }
                    authenticator.addPropertyValue("returnAttributes", (Object)EDirectoryAuthenticationResponseHandler.ATTRIBUTES);
                    break;
                }
                case "free-ipa-handler": {
                    BeanDefinitionBuilder period;
                    responseHandler = BeanDefinitionBuilder.genericBeanDefinition(FreeIPAAuthenticationResponseHandler.class);
                    if (handlerElement.hasAttribute("expirationPeriod")) {
                        period = BeanDefinitionBuilder.rootBeanDefinition(AbstractAuthenticatorBeanDefinitionParser.class, (String)"parsePeriod");
                        period.addConstructorArgValue((Object)handlerElement.getAttribute("expirationPeriod"));
                        responseHandler.addPropertyValue("expirationPeriod", (Object)period.getBeanDefinition());
                    }
                    if (handlerElement.hasAttribute("warningPeriod")) {
                        period = BeanDefinitionBuilder.rootBeanDefinition(AbstractAuthenticatorBeanDefinitionParser.class, (String)"parsePeriod");
                        period.addConstructorArgValue((Object)handlerElement.getAttribute("warningPeriod"));
                        responseHandler.addPropertyValue("warningPeriod", (Object)period.getBeanDefinition());
                    }
                    if (handlerElement.hasAttribute("maxLoginFailures")) {
                        responseHandler.addPropertyValue("maxLoginFailures", (Object)handlerElement.getAttribute("maxLoginFailures"));
                    }
                    authenticator.addPropertyValue("returnAttributes", (Object)FreeIPAAuthenticationResponseHandler.ATTRIBUTES);
                    break;
                }
                case "active-directory-handler": {
                    BeanDefinitionBuilder period;
                    responseHandler = BeanDefinitionBuilder.genericBeanDefinition(ActiveDirectoryAuthenticationResponseHandler.class);
                    if (handlerElement.hasAttribute("expirationPeriod")) {
                        period = BeanDefinitionBuilder.rootBeanDefinition(AbstractAuthenticatorBeanDefinitionParser.class, (String)"parsePeriod");
                        period.addConstructorArgValue((Object)handlerElement.getAttribute("expirationPeriod"));
                        responseHandler.addPropertyValue("expirationPeriod", (Object)period.getBeanDefinition());
                    }
                    if (handlerElement.hasAttribute("warningPeriod")) {
                        period = BeanDefinitionBuilder.rootBeanDefinition(AbstractAuthenticatorBeanDefinitionParser.class, (String)"parsePeriod");
                        period.addConstructorArgValue((Object)handlerElement.getAttribute("warningPeriod"));
                        responseHandler.addPropertyValue("warningPeriod", (Object)period.getBeanDefinition());
                    }
                    authenticator.addPropertyValue("returnAttributes", (Object)ActiveDirectoryAuthenticationResponseHandler.ATTRIBUTES);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown authentication response handler: " + handlerElement.getLocalName());
                }
            }
        }
        if (requestControls != null) {
            authHandler.addPropertyValue("authenticationControls", (Object)requestControls.getBeanDefinition());
        }
        return responseHandler;
    }
}

