/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import leap.core.AppConfig;
import leap.core.BeanFactory;
import leap.core.annotation.ConfigProperty;
import leap.core.annotation.Configurable;
import leap.core.annotation.Inject;
import leap.core.ioc.BeanList;
import leap.core.ioc.PostConfigureBean;
import leap.core.security.crypto.PasswordEncoder;
import leap.core.web.RequestIgnore;
import leap.lang.Args;
import leap.lang.Strings;
import leap.lang.path.AntPathPattern;
import leap.web.security.SecurityConfig;
import leap.web.security.SecurityConfigurator;
import leap.web.security.SecurityFailureHandler;
import leap.web.security.SecurityInterceptor;
import leap.web.security.csrf.CsrfStore;
import leap.web.security.path.SecuredPaths;
import leap.web.security.user.UserStore;

@Configurable(prefix="websecurity")
public class DefaultSecurityConfig
implements SecurityConfig,
SecurityConfigurator,
PostConfigureBean {
    protected BeanFactory factory = null;
    protected boolean enabled = false;
    protected boolean crossContext = false;
    protected Boolean csrfEnabled = null;
    protected boolean authenticateAnyRequests = true;
    protected boolean authorizeAnyRequests = false;
    protected int defaultAuthenticationExpires = 28800;
    protected String returnUrlParameterName = "return_url";
    protected boolean rememberMeEnabled = true;
    protected String rememberMeSecret = null;
    protected String rememberMeCookieName = "remember_me";
    protected String rememberMeParameterName = "remember_me";
    protected String rememberMeExpiresParameterName = "remember_me_expires";
    protected String loginUrl = null;
    protected String loginAction = "/login";
    protected String logoutAction = "/logout";
    protected String logoutSuccessUrl = "redirect:/";
    protected int defaultRememberMeExpires = 604800;
    protected String csrfHeaderName = "X-CSRF-Token";
    protected String csrfParameterName = "csrf_token";
    protected boolean authenticationTokenEnabled = true;
    protected String authenticationTokenCookieName = "auth_token";
    protected String authenticationTokenHeaderName = "X-Auth-Token";
    protected String authenticationTokenType = "jwt";
    protected String tokenSecret = null;
    protected String cookieDomain = null;
    protected List<RequestIgnore> ignores = new ArrayList<RequestIgnore>();
    protected Map<String, SecurityFailureHandler> pathPrefixFailureHandlers = new TreeMap<String, SecurityFailureHandler>(String.CASE_INSENSITIVE_ORDER);
    @Inject
    protected SecuredPaths securedPaths;
    @Inject
    protected PasswordEncoder passwordEncoder;
    @Inject
    protected UserStore userStore;
    @Inject
    protected CsrfStore csrfStore;
    @Inject
    protected BeanList<SecurityInterceptor> interceptors;
    private RequestIgnore[] ignoresArray = new RequestIgnore[0];
    private SecurityInterceptor[] interceptorArray = new SecurityInterceptor[0];
    private final Object interceptorLock = new Object();

    @Override
    public SecurityConfig config() {
        return this;
    }

    @Override
    public SecuredPaths paths() {
        return this.securedPaths;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @ConfigProperty
    public SecurityConfigurator setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public BeanList<SecurityInterceptor> interceptors() {
        return this.interceptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityInterceptor[] getInterceptors() {
        if (this.interceptorArray.length != this.interceptors.size()) {
            Object object = this.interceptorLock;
            synchronized (object) {
                if (this.interceptorArray.length != this.interceptors.size()) {
                    this.interceptorArray = (SecurityInterceptor[])this.interceptors.toArray((Object[])new SecurityInterceptor[this.interceptors.size()]);
                }
            }
        }
        return this.interceptorArray;
    }

    @Override
    public boolean isCrossContext() {
        return this.crossContext;
    }

    @Override
    @ConfigProperty
    public DefaultSecurityConfig setCrossContext(boolean crossContext) {
        this.crossContext = crossContext;
        return this;
    }

    @Override
    public boolean isCsrfEnabled() {
        return this.csrfEnabled == null ? this.enabled : this.csrfEnabled;
    }

    @Override
    @ConfigProperty
    public DefaultSecurityConfig setCsrfEnabled(boolean csrfEnabled) {
        this.csrfEnabled = csrfEnabled;
        return this;
    }

    @Override
    public boolean isAuthenticateAnyRequests() {
        return this.authenticateAnyRequests;
    }

    @Override
    @ConfigProperty
    public DefaultSecurityConfig setAuthenticateAnyRequests(boolean authenticateAnyRequests) {
        this.authenticateAnyRequests = authenticateAnyRequests;
        return this;
    }

    @Override
    public boolean isAuthorizeAnyRequests() {
        return this.authorizeAnyRequests;
    }

    @Override
    @ConfigProperty
    public DefaultSecurityConfig setAuthorizeAnyRequests(boolean authorizeAnyRequests) {
        this.authorizeAnyRequests = authorizeAnyRequests;
        return this;
    }

    @Override
    public UserStore getUserStore() {
        return this.userStore;
    }

    @Override
    public CsrfStore getCsrfStore() {
        return this.csrfStore;
    }

    @Override
    public SecurityConfigurator setUserStore(UserStore userStore) {
        Args.notNull((Object)userStore, (String)"userStore");
        this.userStore = userStore;
        this.factory.setPrimaryBean(UserStore.class, (Object)userStore);
        return this;
    }

    @Override
    public SecurityConfigurator setCsrfStore(CsrfStore csrfStore) {
        Args.notNull((Object)csrfStore, (String)"csrfStore");
        this.csrfStore = csrfStore;
        return this;
    }

    @Override
    public String getReturnUrlParameterName() {
        return this.returnUrlParameterName;
    }

    @ConfigProperty
    public DefaultSecurityConfig setReturnUrlParameterName(String returnUrlParameterName) {
        Args.notEmpty((String)returnUrlParameterName);
        this.returnUrlParameterName = returnUrlParameterName;
        return this;
    }

    @Override
    public boolean isRememberMeEnabled() {
        return this.rememberMeEnabled;
    }

    @Override
    @ConfigProperty
    public DefaultSecurityConfig setRememberMeEnabled(boolean rememberMeEnabled) {
        this.rememberMeEnabled = rememberMeEnabled;
        return this;
    }

    @Override
    public String getRememberMeSecret() {
        return this.rememberMeSecret;
    }

    @Override
    @ConfigProperty
    public DefaultSecurityConfig setRememberMeSecret(String rememberMeSecret) {
        Args.notEmpty((String)rememberMeSecret);
        this.rememberMeSecret = rememberMeSecret;
        return this;
    }

    @Override
    public String getRememberMeCookieName() {
        return this.rememberMeCookieName;
    }

    @Override
    @ConfigProperty
    public DefaultSecurityConfig setRememberMeCookieName(String rememberMeCookieName) {
        Args.notEmpty((String)rememberMeCookieName);
        this.rememberMeCookieName = rememberMeCookieName;
        return this;
    }

    @Override
    public String getRememberMeParameterName() {
        return this.rememberMeParameterName;
    }

    @ConfigProperty
    public DefaultSecurityConfig setRememberMeParameterName(String rememberMeParameterName) {
        Args.notEmpty((String)rememberMeParameterName);
        this.rememberMeParameterName = rememberMeParameterName;
        return this;
    }

    @Override
    public String getRememberMeExpiresParameterName() {
        return this.rememberMeExpiresParameterName;
    }

    @ConfigProperty
    public DefaultSecurityConfig setRememberMeExpiresParameterName(String rememberMeExpiresParameterName) {
        Args.notEmpty((String)rememberMeExpiresParameterName);
        this.rememberMeExpiresParameterName = rememberMeExpiresParameterName;
        return this;
    }

    @Override
    public int getDefaultRememberMeExpires() {
        return this.defaultRememberMeExpires;
    }

    @ConfigProperty
    public DefaultSecurityConfig setDefaultRememberMeExpires(int defaultRememberExpires) {
        Args.assertTrue((defaultRememberExpires > 0 ? 1 : 0) != 0, (String)"Expires must be > 0");
        this.defaultRememberMeExpires = defaultRememberExpires;
        return this;
    }

    @Override
    public String getCsrfHeaderName() {
        return this.csrfHeaderName;
    }

    @Override
    public String getCsrfParameterName() {
        return this.csrfParameterName;
    }

    @Override
    public DefaultSecurityConfig setCsrfHeaderName(String csrfHeaderName) {
        this.csrfHeaderName = csrfHeaderName;
        return this;
    }

    @Override
    @ConfigProperty
    public DefaultSecurityConfig setCsrfParameterName(String csrfParameterName) {
        this.csrfParameterName = csrfParameterName;
        return this;
    }

    @Override
    public boolean isAuthenticationTokenEnabled() {
        return this.authenticationTokenEnabled;
    }

    @Override
    public int getDefaultAuthenticationExpires() {
        return this.defaultAuthenticationExpires;
    }

    @Override
    public String getAuthenticationTokenCookieName() {
        return this.authenticationTokenCookieName;
    }

    @Override
    public String getAuthenticationTokenHeaderName() {
        return this.authenticationTokenHeaderName;
    }

    @ConfigProperty
    public void setAuthenticationTokenHeaderName(String authenticationTokenHeaderName) {
        this.authenticationTokenHeaderName = authenticationTokenHeaderName;
    }

    @Override
    @ConfigProperty
    public DefaultSecurityConfig setAuthenticationTokenEnabled(boolean authenticationTokenEnabled) {
        this.authenticationTokenEnabled = authenticationTokenEnabled;
        return this;
    }

    @ConfigProperty
    public void setAuthenticationTokenCookieName(String authenticationTokenCookieName) {
        this.authenticationTokenCookieName = authenticationTokenCookieName;
    }

    @Override
    public String getAuthenticationTokenType() {
        return this.authenticationTokenType;
    }

    @ConfigProperty
    public void setAuthenticationTokenType(String authenticationTokenType) {
        this.authenticationTokenType = authenticationTokenType;
    }

    @Override
    public String getSecret() {
        return this.tokenSecret;
    }

    @ConfigProperty
    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    @Override
    public String getCookieDomain() {
        return this.cookieDomain;
    }

    @ConfigProperty
    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    @Override
    public String getLoginUrl() {
        if (null == this.loginUrl) {
            return "action:" + this.loginAction;
        }
        return this.loginUrl;
    }

    @Override
    @ConfigProperty
    public DefaultSecurityConfig setLoginUrl(String url) {
        this.loginUrl = url;
        return this;
    }

    @Override
    public String getLoginAction() {
        return this.loginAction;
    }

    @Override
    public String getLogoutAction() {
        return this.logoutAction;
    }

    @Override
    public String getLogoutSuccessUrl() {
        return this.logoutSuccessUrl;
    }

    @Override
    @ConfigProperty
    public SecurityConfigurator setLoginAction(String path) {
        this.loginAction = path;
        return this;
    }

    @Override
    public SecurityConfigurator setLogoutAction(String path) {
        this.logoutAction = path;
        return this;
    }

    @ConfigProperty
    public DefaultSecurityConfig setLogoutSuccessUrl(String url) {
        Args.notEmpty((String)url);
        this.logoutSuccessUrl = url;
        return this;
    }

    @Override
    public SecurityConfigurator setPathPrefixFailureHandler(String pathPrefix, SecurityFailureHandler failureHandler) {
        this.pathPrefixFailureHandlers.put(pathPrefix, failureHandler);
        return this;
    }

    @Override
    public RequestIgnore[] getIgnores() {
        return this.ignoresArray;
    }

    @Override
    public Map<String, SecurityFailureHandler> getPathPrefixFailureHandlers() {
        return this.pathPrefixFailureHandlers;
    }

    @Override
    public SecuredPaths getSecuredPaths() {
        return this.securedPaths;
    }

    @Override
    public SecurityConfigurator ignore(String path) {
        AntPathPattern pattern = new AntPathPattern(path);
        this.ignores.add(req -> pattern.matches(req.getPath()));
        this.ignoresArray = this.ignores.toArray(new RequestIgnore[this.ignores.size()]);
        return this;
    }

    @Override
    public SecurityConfigurator setPasswordEncoder(PasswordEncoder encoder) {
        Args.notNull((Object)encoder, (String)"password encoder");
        this.passwordEncoder = encoder;
        return this;
    }

    @Override
    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void postConfigure(BeanFactory factory, AppConfig config) throws Throwable {
        this.factory = factory;
        if (Strings.isEmpty((String)this.rememberMeSecret)) {
            this.rememberMeSecret = config.ensureGetSecret();
        }
        if (Strings.isEmpty((String)this.tokenSecret)) {
            this.tokenSecret = config.ensureGetSecret();
        }
    }
}

