/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security;

import leap.core.security.Authentication;
import leap.core.security.Authorization;
import leap.core.security.Credentials;
import leap.core.security.SecurityContext;
import leap.core.security.UserPrincipal;
import leap.core.validation.Validation;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.web.Request;
import leap.web.security.SecurityConfig;
import leap.web.security.SecurityContextHolder;
import leap.web.security.authc.AuthenticationContext;
import leap.web.security.login.LoginContext;
import leap.web.security.logout.LogoutContext;
import leap.web.security.path.SecuredPath;
import leap.web.security.permission.PermissionManager;

public class DefaultSecurityContextHolder
extends SecurityContext
implements SecurityContextHolder {
    private static final Log log = LogFactory.get(DefaultSecurityContextHolder.class);
    protected final SecurityConfig config;
    protected final PermissionManager permissionManager;
    protected final Request request;
    protected SecuredPath securedPath;
    protected LoginContext loginContext;
    protected LogoutContext logoutContext;
    protected String authenticationToken;
    protected boolean error;
    protected Object errorObj;
    protected String identity;
    private boolean handled;

    static DefaultSecurityContextHolder tryGet(Request request) {
        return (DefaultSecurityContextHolder)request.getAttribute(CONTEXT_HOLDER_ATTRIBUTE_NAME);
    }

    static void remove(Request request) {
        request.removeAttribute(CONTEXT_ATTRIBUTE_NAME);
    }

    public DefaultSecurityContextHolder(SecurityConfig config, PermissionManager permissionManager, Request request) {
        this.config = config;
        this.permissionManager = permissionManager;
        this.request = request;
        request.setAttribute(CONTEXT_ATTRIBUTE_NAME, (Object)this);
        request.setAttribute(CONTEXT_HOLDER_ATTRIBUTE_NAME, (Object)this);
    }

    public Validation validation() {
        return this.request.getValidation();
    }

    @Override
    public SecurityConfig getSecurityConfig() {
        return this.config;
    }

    @Override
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this;
    }

    @Override
    public SecuredPath getSecuredPath() {
        return this.securedPath;
    }

    public void setSecuredPath(SecuredPath path) {
        this.securedPath = path;
    }

    @Override
    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    @Override
    public void setAuthenticationToken(String token) {
        log.debug("Set authentication token : {}", new Object[]{token});
        this.authenticationToken = token;
    }

    @Override
    public void setAuthentication(Authentication authc) {
        log.debug("Set authentication : {}", new Object[]{authc});
        this.authentication = authc;
    }

    @Override
    public void setAuthorization(Authorization authz) {
        log.debug("Set authorization : {}", new Object[]{authz});
        this.authorization = authz;
    }

    @Override
    public LoginContext getLoginContext() {
        if (null == this.loginContext) {
            this.loginContext = new DefaultLoginContext();
        }
        return this.loginContext;
    }

    @Override
    public LogoutContext getLogoutContext() {
        if (null == this.logoutContext) {
            this.logoutContext = new DefaultLogoutContext();
        }
        return this.logoutContext;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public void setError(boolean error) {
        this.error = error;
    }

    @Override
    public Object getErrorObj() {
        return this.errorObj;
    }

    @Override
    public void setErrorObj(Object obj) {
        this.errorObj = obj;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    boolean isHandled() {
        return this.handled;
    }

    void markHandled() {
        this.handled = true;
    }

    protected final class DefaultLogoutContext
    extends AbstractContext
    implements LogoutContext {
        private String returnUrl;

        protected DefaultLogoutContext() {
        }

        @Override
        public String getAuthenticationToken() {
            return DefaultSecurityContextHolder.this.getAuthenticationToken();
        }

        @Override
        public void setAuthenticationToken(String token) {
            DefaultSecurityContextHolder.this.setAuthenticationToken(token);
        }

        @Override
        public Authentication getAuthentication() {
            return DefaultSecurityContextHolder.this.authentication;
        }

        @Override
        public void setAuthentication(Authentication auth) {
            DefaultSecurityContextHolder.this.setAuthentication(auth);
        }

        @Override
        public String getReturnUrl() {
            return this.returnUrl;
        }

        @Override
        public void setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
        }
    }

    protected final class DefaultLoginContext
    extends AbstractContext
    implements LoginContext {
        private String returnUrl;
        private String loginUrl;
        private Credentials credentials;
        private UserPrincipal user;

        protected DefaultLoginContext() {
        }

        @Override
        public String getAuthenticationToken() {
            return DefaultSecurityContextHolder.this.getAuthenticationToken();
        }

        @Override
        public void setAuthenticationToken(String token) {
            DefaultSecurityContextHolder.this.setAuthenticationToken(token);
        }

        @Override
        public Authentication getAuthentication() {
            return DefaultSecurityContextHolder.this.authentication;
        }

        @Override
        public void setAuthentication(Authentication auth) {
            DefaultSecurityContextHolder.this.setAuthentication(auth);
        }

        @Override
        public String getReturnUrl() {
            return this.returnUrl;
        }

        @Override
        public void setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
        }

        @Override
        public String getLoginUrl() {
            return this.loginUrl;
        }

        @Override
        public void setLoginUrl(String url) {
            this.loginUrl = url;
        }

        @Override
        public boolean isCredentialsResolved() {
            return null != this.credentials;
        }

        @Override
        public Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public void setCredentials(Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public boolean isAuthenticated() {
            return null != this.user && !this.user.isAnonymous();
        }

        @Override
        public UserPrincipal getUser() {
            return this.user;
        }

        @Override
        public void setUser(UserPrincipal user) {
            this.user = user;
        }
    }

    protected abstract class AbstractContext
    implements AuthenticationContext {
        private boolean error;
        private Object errorObj;

        protected AbstractContext() {
        }

        @Override
        public SecurityConfig getSecurityConfig() {
            return DefaultSecurityContextHolder.this.config;
        }

        @Override
        public SecurityContext getSecurityContext() {
            return DefaultSecurityContextHolder.this;
        }

        public Validation validation() {
            return DefaultSecurityContextHolder.this.validation();
        }

        @Override
        public Object getErrorObj() {
            return this.errorObj;
        }

        @Override
        public void setErrorObj(Object obj) {
            this.errorObj = obj;
        }

        @Override
        public boolean isError() {
            return this.error;
        }

        @Override
        public void setError(boolean error) {
            this.error = error;
        }

        @Override
        public String getIdentity() {
            return DefaultSecurityContextHolder.this.identity;
        }

        @Override
        public void setIdentity(String identity) {
            DefaultSecurityContextHolder.this.identity = identity;
        }
    }
}

