/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security;

import leap.core.annotation.Inject;
import leap.core.security.Authentication;
import leap.core.security.Authorization;
import leap.lang.http.HTTP;
import leap.lang.intercepting.State;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.web.Request;
import leap.web.Response;
import leap.web.security.SecurityConfig;
import leap.web.security.SecurityContextHolder;
import leap.web.security.SecurityHandler;
import leap.web.security.SecurityInterceptor;
import leap.web.security.authc.AuthenticationManager;
import leap.web.security.authz.AuthorizationManager;
import leap.web.security.login.LoginManager;
import leap.web.security.logout.LogoutManager;
import leap.web.security.path.SecuredPath;

public class DefaultSecurityHandler
implements SecurityHandler {
    private static final Log log = LogFactory.get(DefaultSecurityHandler.class);
    @Inject
    protected SecurityConfig config;
    @Inject
    protected AuthenticationManager authcManager;
    @Inject
    protected AuthorizationManager authzManager;
    @Inject
    protected LoginManager loginManager;
    @Inject
    protected LogoutManager logoutManager;

    @Override
    public Authentication resolveAuthentication(Request request, Response response, SecurityContextHolder context) throws Throwable {
        return this.authcManager.resolveAuthentication(request, response, context);
    }

    @Override
    public Authorization resolveAuthorization(Request request, Response response, SecurityContextHolder context) throws Throwable {
        return this.authzManager.resolveAuthorization(request, response, context);
    }

    @Override
    public boolean checkAuthentication(Request request, Response response, SecurityContextHolder context) throws Throwable {
        SecuredPath path = context.getSecuredPath();
        if (null != path) {
            return path.checkAuthentication(request, context);
        }
        return true;
    }

    @Override
    public boolean checkAuthorization(Request request, Response response, SecurityContextHolder context) throws Throwable {
        SecuredPath path = context.getSecuredPath();
        if (!this.authzManager.checkAuthorization(request, response, context)) {
            return false;
        }
        if (null != path) {
            return path.checkAuthorization(request, context);
        }
        return true;
    }

    @Override
    public void handleAuthenticationDenied(Request request, Response response, SecurityContextHolder context) throws Throwable {
        SecuredPath path = context.getSecuredPath();
        if (null != path && null != path.getFailureHandler() && path.getFailureHandler().handleAuthenticationDenied(request, response, context)) {
            return;
        }
        for (SecurityInterceptor si : this.config.getInterceptors()) {
            if (!State.isIntercepted((State)si.onAuthenticationDenied(request, response, context))) continue;
            return;
        }
        this.loginManager.promoteLogin(request, response, context.getLoginContext());
    }

    @Override
    public void handleAuthorizationDenied(Request request, Response response, SecurityContextHolder context) throws Throwable {
        SecuredPath path = context.getSecuredPath();
        if (null != path && null != path.getFailureHandler() && path.getFailureHandler().handleAuthorizationDenied(request, response, context)) {
            return;
        }
        for (SecurityInterceptor si : this.config.getInterceptors()) {
            if (!State.isIntercepted((State)si.onAuthorizationDenied(request, response, context))) continue;
            return;
        }
        if (request.isAjax()) {
            response.setStatus(HTTP.SC_FORBIDDEN);
        } else {
            response.sendError(HTTP.SC_FORBIDDEN);
        }
    }

    @Override
    public boolean handleLoginRequest(Request request, Response response, SecurityContextHolder context) throws Throwable {
        return this.loginManager.handleLoginRequest(request, response, context.getLoginContext());
    }

    @Override
    public boolean handleLogoutRequest(Request request, Response response, SecurityContextHolder context) throws Throwable {
        return this.logoutManager.handleLogoutRequest(request, response, context.getLogoutContext());
    }
}

