/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import leap.core.Session;
import leap.core.security.Authentication;
import leap.core.web.RequestBase;
import leap.web.security.SecuritySessionManager;

public class DefaultSecuritySessionManager
implements SecuritySessionManager {
    private static final String SESSION_KEY = DefaultSecuritySessionManager.class.getName() + "$User";

    @Override
    public Authentication getAuthentication(RequestBase request) {
        Session sc = request.getSession(false);
        if (null == sc) {
            return null;
        }
        return (Authentication)sc.getAttribute(SESSION_KEY);
    }

    @Override
    public void saveAuthentication(RequestBase request, Authentication authentication) {
        HashMap<String, Object> attrs = null;
        Session sc = request.getSession(false);
        if (null != sc) {
            HttpSession hs = sc.getServletSession();
            Enumeration names = hs.getAttributeNames();
            if (names.hasMoreElements()) {
                attrs = new HashMap<String, Object>();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    attrs.put(name, hs.getAttribute(name));
                }
            }
            sc.invalidate();
        }
        sc = request.getSession(true);
        if (null != attrs) {
            for (Map.Entry entry : attrs.entrySet()) {
                sc.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        sc.setAttribute(SESSION_KEY, (Object)authentication);
    }

    @Override
    public Authentication removeAuthentication(RequestBase request) {
        Session sc = request.getSession(false);
        if (null == sc) {
            return null;
        }
        Authentication us = (Authentication)sc.getAttribute(SESSION_KEY);
        if (null != us) {
            sc.removeAttribute(SESSION_KEY);
            sc.invalidate();
        }
        return us;
    }
}

